/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.cartridges.json.KeyMapDigester;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JSONReader
implements SmooksXMLReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONReader.class);
    public static final String CONFIG_PARAM_KEY_MAP = "keyMap";
    public static final String XML_ROOT = "json";
    public static final String XML_ARRAY_ELEMENT_NAME = "element";
    public static final String DEFAULT_NULL_VALUE_REPLACEMENT = "";
    private static final Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static final JsonFactory jsonFactory = new JsonFactory();
    private ContentHandler contentHandler;
    private ExecutionContext executionContext;
    @Inject
    private String rootName = "json";
    @Inject
    private String arrayElementName = "element";
    @Inject
    private Optional<String> keyWhitspaceReplacement;
    @Inject
    private Optional<String> keyPrefixOnNumeric;
    @Inject
    private Optional<String> illegalElementNameCharReplacement;
    @Inject
    private String nullValueReplacement = "";
    @Inject
    private Charset encoding = StandardCharsets.UTF_8;
    @Inject
    private Boolean indent = false;
    @Inject
    private ResourceConfig resourceConfig;
    private boolean doKeyReplacement = false;
    private boolean doKeyWhitspaceReplacement = false;
    private boolean doPrefixOnNumericKey = false;
    private boolean doIllegalElementNameCharReplacement = false;
    private HashMap<String, String> keyMap = new HashMap();
    private static char[] INDENT = "\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".toCharArray();

    @PostConstruct
    public void initialize() {
        this.initKeyMap();
        this.doKeyReplacement = !this.keyMap.isEmpty();
        this.doKeyWhitspaceReplacement = this.keyWhitspaceReplacement.isPresent();
        this.doPrefixOnNumericKey = this.keyPrefixOnNumeric.isPresent();
        this.doIllegalElementNameCharReplacement = this.illegalElementNameCharReplacement.isPresent();
    }

    public void setExecutionContext(ExecutionContext request) {
        this.executionContext = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource csvInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse JSON stream.");
        }
        if (this.executionContext == null) {
            throw new IllegalStateException("Smooks container 'executionContext' not set.  Cannot parse JSON stream.");
        }
        try {
            Reader jsonStreamReader = csvInputSource.getCharacterStream();
            if (jsonStreamReader == null) {
                jsonStreamReader = new InputStreamReader(csvInputSource.getByteStream(), this.encoding);
            }
            JsonParser jp = null;
            try {
                JsonToken t;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Creating JSON parser");
                }
                jp = jsonFactory.createJsonParser(jsonStreamReader);
                this.contentHandler.startDocument();
                this.startElement(this.rootName, 0);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Starting JSON parsing");
                }
                boolean first = true;
                Stack<String> elementStack = new Stack<String>();
                Stack<Type> typeStack = new Stack<Type>();
                while ((t = jp.nextToken()) != null) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Token: " + t.name());
                    }
                    switch (t) {
                        case START_OBJECT: 
                        case START_ARRAY: {
                            if (!first && !typeStack.empty() && typeStack.peek() == Type.ARRAY) {
                                this.startElement(this.arrayElementName, typeStack.size());
                            }
                            typeStack.push(t == JsonToken.START_ARRAY ? Type.ARRAY : Type.OBJECT);
                            break;
                        }
                        case END_OBJECT: 
                        case END_ARRAY: {
                            boolean typeStackPeekIsArray;
                            typeStack.pop();
                            boolean bl = typeStackPeekIsArray = !typeStack.empty() && typeStack.peek() == Type.ARRAY;
                            if (!elementStack.empty() && !typeStackPeekIsArray) {
                                this.endElement((String)elementStack.pop(), typeStack.size());
                            }
                            if (!typeStackPeekIsArray) break;
                            this.endElement(this.arrayElementName, typeStack.size());
                            break;
                        }
                        case FIELD_NAME: {
                            String text = jp.getText();
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Field name: " + text);
                            }
                            String name = this.getElementName(text);
                            this.startElement(name, typeStack.size());
                            elementStack.add(name);
                            break;
                        }
                        default: {
                            String value = t == JsonToken.VALUE_NULL ? this.nullValueReplacement : jp.getText();
                            if (typeStack.peek() == Type.ARRAY) {
                                this.startElement(this.arrayElementName, typeStack.size());
                            }
                            this.contentHandler.characters(value.toCharArray(), 0, value.length());
                            if (typeStack.peek() == Type.ARRAY) {
                                this.endElement(this.arrayElementName);
                                break;
                            }
                            this.endElement((String)elementStack.pop());
                        }
                    }
                    first = false;
                }
                this.endElement(this.rootName, 0);
                this.contentHandler.endDocument();
            }
            finally {
                try {
                    jp.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.contentHandler = null;
            this.executionContext = null;
        }
    }

    private void startElement(String name, int indent) throws SAXException {
        this.indent(indent);
        this.contentHandler.startElement(DEFAULT_NULL_VALUE_REPLACEMENT, name, DEFAULT_NULL_VALUE_REPLACEMENT, EMPTY_ATTRIBS);
    }

    private void endElement(String name, int indent) throws SAXException {
        this.indent(indent);
        this.endElement(name);
    }

    private void endElement(String name) throws SAXException {
        this.contentHandler.endElement(DEFAULT_NULL_VALUE_REPLACEMENT, name, DEFAULT_NULL_VALUE_REPLACEMENT);
    }

    private void indent(int indentAmount) throws SAXException {
        if (this.indent.booleanValue()) {
            if (indentAmount > 0) {
                this.contentHandler.characters(INDENT, 0, indentAmount + 1);
            } else {
                this.contentHandler.characters(INDENT, 0, 1);
            }
        }
    }

    private String getElementName(String text) {
        boolean replacedKey = false;
        if (this.doKeyReplacement) {
            String mappedKey = this.keyMap.get(text);
            boolean bl = replacedKey = mappedKey != null;
            if (replacedKey) {
                text = mappedKey;
            }
        }
        if (!replacedKey) {
            if (this.doKeyWhitspaceReplacement) {
                text = text.replace(" ", this.keyWhitspaceReplacement.get());
            }
            if (this.doPrefixOnNumericKey && Character.isDigit(text.charAt(0))) {
                text = this.keyPrefixOnNumeric.get() + text;
            }
            if (this.doIllegalElementNameCharReplacement) {
                text = text.replaceAll("^[.]|[^a-zA-Z0-9_.-]", this.illegalElementNameCharReplacement.get());
            }
        }
        return text;
    }

    private void initKeyMap() {
        Parameter keyMapParam = this.resourceConfig.getParameter(CONFIG_PARAM_KEY_MAP, Object.class);
        if (keyMapParam != null) {
            Object objValue = keyMapParam.getValue();
            if (objValue instanceof Map) {
                this.keyMap = (HashMap)objValue;
            } else {
                Element keyMapParamElement = keyMapParam.getXml();
                if (keyMapParamElement != null) {
                    this.setKeyMap(KeyMapDigester.digest(keyMapParamElement));
                } else {
                    LOGGER.error("Sorry, the key properties must be available as XML DOM. Please configure using XML.");
                }
            }
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public HashMap<String, String> getKeyMap() {
        return this.keyMap;
    }

    public void setKeyMap(HashMap<String, String> keyMap) {
        this.keyMap = keyMap;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getArrayElementName() {
        return this.arrayElementName;
    }

    public void setArrayElementName(String arrayElementName) {
        this.arrayElementName = arrayElementName;
    }

    public String getKeyWhitspaceReplacement() {
        return this.keyWhitspaceReplacement.orElse(this.nullValueReplacement);
    }

    public void setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        this.keyWhitspaceReplacement = Optional.ofNullable(keyWhitspaceReplacement);
    }

    public String getKeyPrefixOnNumeric() {
        return this.keyPrefixOnNumeric.orElse(null);
    }

    public void setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        this.keyPrefixOnNumeric = Optional.ofNullable(keyPrefixOnNumeric);
    }

    public String getIllegalElementNameCharReplacement() {
        return this.illegalElementNameCharReplacement.orElse(null);
    }

    public void setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        this.illegalElementNameCharReplacement = Optional.ofNullable(illegalElementNameCharReplacement);
    }

    public String getNullValueReplacement() {
        return this.nullValueReplacement;
    }

    public void setNullValueReplacement(String nullValueReplacement) {
        this.nullValueReplacement = nullValueReplacement;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void parse(String systemId) {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setFeature(String name, boolean value) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value) {
    }

    private static enum Type {
        OBJECT,
        ARRAY;

    }
}

