/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.json;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.json.JSONReader;
import org.smooks.engine.resource.config.DefaultParameter;
import org.smooks.engine.resource.config.GenericReaderConfigurator;

public class JSONReaderConfigurator
implements ReaderConfigurator {
    private String rootName = "json";
    private String arrayElementName = "element";
    private String keyWhitspaceReplacement;
    private String keyPrefixOnNumeric;
    private String illegalElementNameCharReplacement;
    private String nullValueReplacement = "";
    private Charset encoding = Charset.forName("UTF-8");
    private Map<String, String> keyMap;
    private String targetProfile;

    public JSONReaderConfigurator setRootName(String rootName) {
        AssertArgument.isNotNull((Object)rootName, (String)"rootName");
        this.rootName = rootName;
        return this;
    }

    public JSONReaderConfigurator setArrayElementName(String arrayElementName) {
        AssertArgument.isNotNull((Object)arrayElementName, (String)"arrayElementName");
        this.arrayElementName = arrayElementName;
        return this;
    }

    public JSONReaderConfigurator setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        AssertArgument.isNotNull((Object)keyWhitspaceReplacement, (String)"keyWhitspaceReplacement");
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
        return this;
    }

    public JSONReaderConfigurator setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        AssertArgument.isNotNull((Object)keyPrefixOnNumeric, (String)"keyPrefixOnNumeric");
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
        return this;
    }

    public JSONReaderConfigurator setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        AssertArgument.isNotNull((Object)illegalElementNameCharReplacement, (String)"illegalElementNameCharReplacement");
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
        return this;
    }

    public JSONReaderConfigurator setNullValueReplacement(String nullValueReplacement) {
        AssertArgument.isNotNull((Object)nullValueReplacement, (String)"nullValueReplacement");
        this.nullValueReplacement = nullValueReplacement;
        return this;
    }

    public JSONReaderConfigurator setEncoding(Charset encoding) {
        AssertArgument.isNotNull((Object)encoding, (String)"encoding");
        this.encoding = encoding;
        return this;
    }

    public JSONReaderConfigurator setKeyMap(Map<String, String> keyMap) {
        AssertArgument.isNotNull(keyMap, (String)"keyMap");
        this.keyMap = keyMap;
        return this;
    }

    public JSONReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty((String)targetProfile, (String)"targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    public List<ResourceConfig> toConfig() {
        GenericReaderConfigurator configurator = new GenericReaderConfigurator(JSONReader.class);
        configurator.getParameters().setProperty("rootName", this.rootName);
        configurator.getParameters().setProperty("arrayElementName", this.arrayElementName);
        if (this.keyWhitspaceReplacement != null) {
            configurator.getParameters().setProperty("keyWhitspaceReplacement", this.keyWhitspaceReplacement);
        }
        if (this.keyPrefixOnNumeric != null) {
            configurator.getParameters().setProperty("keyPrefixOnNumeric", this.keyPrefixOnNumeric);
        }
        if (this.illegalElementNameCharReplacement != null) {
            configurator.getParameters().setProperty("illegalElementNameCharReplacement", this.illegalElementNameCharReplacement);
        }
        configurator.getParameters().setProperty("nullValueReplacement", this.nullValueReplacement);
        configurator.getParameters().setProperty("encoding", this.encoding.name());
        List configList = configurator.toConfig();
        ResourceConfig resourceConfig = (ResourceConfig)configList.get(0);
        if (this.keyMap != null) {
            DefaultParameter keyMapParam = new DefaultParameter("keyMap", this.keyMap);
            resourceConfig.setParameter((Parameter)keyMapParam);
        }
        resourceConfig.setTargetProfile(this.targetProfile);
        return configList;
    }
}

