/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing;

import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JNDIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JNDIUtil.class);

    private JNDIUtil() {
    }

    public static Context getNamingContext(Properties jndiProperties) throws NamingException {
        InitialContext context;
        try {
            context = jndiProperties.isEmpty() ? new InitialContext() : new InitialContext(jndiProperties);
        }
        catch (NamingException e) {
            LOGGER.error("NamingException while try to create initialContext. jndiProperties are " + jndiProperties, (Throwable)e);
            throw (NamingException)new NamingException("Failed to load InitialContext: " + jndiProperties).initCause(e);
        }
        if (context == null) {
            throw new NamingException("Failed to create JNDI context.  Check that 'java.naming.provider.url', 'java.naming.factory.initial', 'java.naming.factory.url.pkgs' are correctly configured in the supplied JNDI properties.");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(String objectName, Properties jndiProperties) throws NamingException {
        Object object = null;
        Context context = JNDIUtil.getNamingContext(jndiProperties);
        try {
            object = context.lookup(objectName);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException ne) {
                LOGGER.debug("Failed to close Naming Context.", (Throwable)ne);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object lookup(String objectName, Properties jndiProperties, ClassLoader[] classLoaders) throws NamingException {
        ClassLoader tcClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (ClassLoader classLoader : classLoaders) {
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    Object object = JNDIUtil.lookup(objectName, jndiProperties);
                    return object;
                }
                catch (NamingException e) {
                    try {
                        LOGGER.debug("NamingException while trying to lookup '" + objectName + "' using JNDI Properties '" + jndiProperties + "', classloader used '" + classLoader + "'", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new NamingException("JNDI lookup of Object [" + objectName + "] failed.");
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcClassLoader);
        }
    }

    public static Properties getDefaultProperties() {
        Properties defaultProperties = new Properties();
        try {
            InitialContext context = new InitialContext();
            defaultProperties.putAll((Map<?, ?>)context.getEnvironment());
        }
        catch (Exception e) {
            LOGGER.debug("Unexpected exception when trying to retrieve default naming context.", (Throwable)e);
        }
        return defaultProperties;
    }
}

