/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.basic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleEvent;
import org.smooks.api.bean.lifecycle.BeanLifecycle;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.lifecycle.VisitLifecycleCleanable;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.engine.bean.lifecycle.DefaultBeanContextLifecycleEvent;
import org.smooks.engine.delivery.dom.serialize.DefaultDOMSerializerVisitor;
import org.smooks.engine.delivery.event.EndFragmentEvent;
import org.smooks.engine.delivery.event.StartFragmentEvent;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.sax.ng.CharDataFragmentEvent;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.namespace.NamespaceDeclarationStack;
import org.smooks.support.CollectionsUtil;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FragmentSerializer
implements BeforeVisitor,
AfterVisitor,
Producer,
VisitLifecycleCleanable {
    private static final TypedKey<Map<String, FragmentSerializerVisitor>> FRAGMENT_SERIALIZER_TYPED_KEY = new TypedKey();
    private String bindTo;
    private boolean omitXMLDeclaration;
    private boolean childContentOnly;
    private boolean retain;

    @Inject
    public FragmentSerializer setBindTo(String bindTo) {
        this.bindTo = bindTo;
        return this;
    }

    @Inject
    public FragmentSerializer setOmitXMLDeclaration(Optional<Boolean> omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration.orElse(false);
        return this;
    }

    @Inject
    public FragmentSerializer setChildContentOnly(Optional<Boolean> childContentOnly) {
        this.childContentOnly = childContentOnly.orElse(false);
        return this;
    }

    @Inject
    public FragmentSerializer setRetain(Optional<Boolean> retain) {
        this.retain = retain.orElse(false);
        return this;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.bindTo});
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        HashMap<String, FragmentSerializerVisitor> fragmentSerializers = (HashMap<String, FragmentSerializerVisitor>)executionContext.get(FRAGMENT_SERIALIZER_TYPED_KEY);
        if (fragmentSerializers == null) {
            fragmentSerializers = new HashMap<String, FragmentSerializerVisitor>();
            executionContext.put(FRAGMENT_SERIALIZER_TYPED_KEY, fragmentSerializers);
        }
        FragmentSerializerVisitor serializer = new FragmentSerializerVisitor(executionContext);
        fragmentSerializers.put(this.bindTo, serializer);
        if (!this.omitXMLDeclaration) {
            serializer.fragmentWriter.write("<?xml version=\"1.0\"?>\n");
        }
        executionContext.getContentDeliveryRuntime().addExecutionEventListener((ExecutionEventListener)serializer);
        this.notifyStartBean(new NodeFragment((Node)element), executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        Map fragmentSerializers = (Map)executionContext.get(FRAGMENT_SERIALIZER_TYPED_KEY);
        FragmentSerializerVisitor serializer = (FragmentSerializerVisitor)fragmentSerializers.get(this.bindTo);
        try {
            executionContext.getBeanContext().addBean(this.bindTo, (Object)serializer.fragmentWriter.toString().trim(), (Fragment)new NodeFragment((Node)element));
        }
        finally {
            executionContext.getContentDeliveryRuntime().removeExecutionEventListener((ExecutionEventListener)serializer);
        }
    }

    private void notifyStartBean(NodeFragment source, ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        beanContext.notifyObservers((BeanContextLifecycleEvent)new DefaultBeanContextLifecycleEvent(executionContext, (Fragment)source, BeanLifecycle.START_FRAGMENT, beanContext.getBeanId(this.bindTo), (Object)""));
    }

    public void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        BeanId beanId = beanContext.getBeanId(this.bindTo);
        Object bean = beanContext.getBean(beanId);
        beanContext.notifyObservers((BeanContextLifecycleEvent)new DefaultBeanContextLifecycleEvent(executionContext, fragment, BeanLifecycle.END_FRAGMENT, beanId, bean));
        if (!this.retain) {
            executionContext.getBeanContext().removeBean(beanId, null);
        }
    }

    private class FragmentSerializerVisitor
    implements ExecutionEventListener {
        private final ExecutionContext executionContext;
        private final StringWriter fragmentWriter = new StringWriter();
        private final DefaultDOMSerializerVisitor serializerVisitor;
        private int depth = 0;

        public FragmentSerializerVisitor(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            this.serializerVisitor = new DefaultDOMSerializerVisitor();
            this.serializerVisitor.postConstruct();
        }

        public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
            Element copyElement = (Element)element.cloneNode(false);
            if (this.depth == 0) {
                this.addRootNamespaces(copyElement, executionContext);
            }
            if (FragmentSerializer.this.childContentOnly) {
                if (this.depth > 0) {
                    try {
                        this.serializerVisitor.writeStartElement(copyElement, (Writer)this.fragmentWriter, null);
                    }
                    catch (IOException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                try {
                    this.serializerVisitor.writeStartElement(copyElement, (Writer)this.fragmentWriter, null);
                }
                catch (IOException e) {
                    throw new SmooksException(e.getMessage(), (Throwable)e);
                }
            }
            ++this.depth;
        }

        public void visitChildText(CharacterData characterData, ExecutionContext executionContext) throws SmooksException {
            try {
                this.serializerVisitor.writeCharacterData((Node)characterData, (Writer)this.fragmentWriter, executionContext);
            }
            catch (IOException e) {
                throw new SmooksException(e.getMessage(), (Throwable)e);
            }
        }

        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            --this.depth;
            if (FragmentSerializer.this.childContentOnly) {
                if (this.depth > 0) {
                    try {
                        this.serializerVisitor.writeEndElement(element, (Writer)this.fragmentWriter, null);
                    }
                    catch (IOException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                try {
                    this.serializerVisitor.writeEndElement(element, (Writer)this.fragmentWriter, null);
                }
                catch (IOException e) {
                    throw new SmooksException(e.getMessage(), (Throwable)e);
                }
            }
        }

        private void addRootNamespaces(Element element, ExecutionContext executionContext) {
            NamespaceDeclarationStack nsDeclStack = (NamespaceDeclarationStack)executionContext.get(NamespaceManager.NAMESPACE_DECLARATION_STACK_TYPED_KEY);
            Map rootNamespaces = nsDeclStack.getActiveNamespaces();
            if (!rootNamespaces.isEmpty()) {
                Set namespaces = rootNamespaces.entrySet();
                for (Map.Entry namespace : namespaces) {
                    this.addNamespace((String)namespace.getKey(), (String)namespace.getValue(), element);
                }
            }
        }

        private void addNamespace(String prefix, String namespaceURI, Element element) {
            if (prefix == null || namespaceURI == null) {
                return;
            }
            if (prefix.equals("") && namespaceURI.equals("")) {
                return;
            }
            String prefixNS = element.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (prefixNS != null && prefixNS.length() != 0) {
                return;
            }
            if (prefix.length() > 0) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
            } else {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
            }
        }

        public void onEvent(ExecutionEvent executionEvent) {
            if (executionEvent instanceof StartFragmentEvent) {
                StartFragmentEvent startFragmentEvent = (StartFragmentEvent)executionEvent;
                this.visitBefore((Element)startFragmentEvent.getFragment().unwrap(), this.executionContext);
            } else if (executionEvent instanceof CharDataFragmentEvent) {
                CharDataFragmentEvent charDataFragmentEvent = (CharDataFragmentEvent)executionEvent;
                this.visitChildText((CharacterData)charDataFragmentEvent.getFragment().unwrap(), this.executionContext);
            } else if (executionEvent instanceof EndFragmentEvent) {
                EndFragmentEvent endFragmentEvent = (EndFragmentEvent)executionEvent;
                this.visitAfter((Element)endFragmentEvent.getFragment().unwrap(), this.executionContext);
            }
        }
    }
}

