/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.visitor.VisitAfterIf;
import org.smooks.api.resource.visitor.VisitBeforeIf;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.routing.db.DataSelectionException;
import org.smooks.cartridges.routing.db.SQLExecutor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.support.CollectionsUtil;
import org.smooks.support.FreeMarkerTemplate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeIf(condition="executeBefore")
@VisitAfterIf(condition="!executeBefore")
public class ResultSetRowSelector
implements BeforeVisitor,
AfterVisitor,
Producer,
Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetRowSelector.class);
    @Inject
    private String resultSetName;
    @Inject
    @Named(value="where")
    private ExpressionEvaluator whereEvaluator;
    @Inject
    private Optional<FreeMarkerTemplate> failedSelectError;
    @Inject
    @Named(value="beanId")
    private String beanId;
    @Inject
    private Boolean executeBefore = true;
    private BeanId resultSetBeanId;
    private BeanId beanIdObj;
    @Inject
    private ApplicationContext appContext;

    public ResultSetRowSelector setResultSetName(String resultSetName) {
        AssertArgument.isNotNullAndNotEmpty((String)resultSetName, (String)"resultSetName");
        this.resultSetName = resultSetName;
        return this;
    }

    public ResultSetRowSelector setSelector(SQLExecutor executor) {
        AssertArgument.isNotNull((Object)executor, (String)"executor");
        this.resultSetName = executor.getResultSetName();
        if (this.resultSetName == null) {
            throw new IllegalArgumentException("Invalid 'executor' argument.  Executor must specify a 'resultSetName' in order to be used by a ResultsetRowSelector.");
        }
        return this;
    }

    public ResultSetRowSelector setWhereClause(String whereClause) {
        AssertArgument.isNotNullAndNotEmpty((String)whereClause, (String)"whereClause");
        this.whereEvaluator = new MVELExpressionEvaluator();
        this.whereEvaluator.setExpression(whereClause);
        return this;
    }

    public ResultSetRowSelector setWhereEvaluator(ExpressionEvaluator whereEvaluator) {
        AssertArgument.isNotNull((Object)whereEvaluator, (String)"whereEvaluator");
        this.whereEvaluator = whereEvaluator;
        return this;
    }

    public ResultSetRowSelector setFailedSelectError(String failedSelectError) {
        AssertArgument.isNotNullAndNotEmpty((String)failedSelectError, (String)"failedSelectError");
        this.failedSelectError = Optional.of(new FreeMarkerTemplate(failedSelectError));
        return this;
    }

    public ResultSetRowSelector setBeanId(String beanId) {
        AssertArgument.isNotNullAndNotEmpty((String)beanId, (String)"beanId");
        this.beanId = beanId;
        return this;
    }

    public ResultSetRowSelector setExecuteBefore(boolean executeBefore) {
        this.executeBefore = executeBefore;
        return this;
    }

    public boolean getExecuteBefore() {
        return this.executeBefore;
    }

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        BeanIdStore beanIdStore = this.appContext.getBeanIdStore();
        this.beanIdObj = beanIdStore.register(this.beanId);
        this.resultSetBeanId = beanIdStore.register(this.resultSetName);
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanId});
    }

    public boolean consumes(Object object) {
        if (object.equals(this.resultSetName)) {
            return true;
        }
        if (this.whereEvaluator != null && this.whereEvaluator.getExpression().contains(object.toString())) {
            return true;
        }
        return this.failedSelectError != null && this.failedSelectError.isPresent() && this.failedSelectError.get().getTemplateText().contains(object.toString());
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.selectRow(executionContext, new NodeFragment((Node)element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.selectRow(executionContext, new NodeFragment((Node)element));
    }

    private void selectRow(ExecutionContext executionContext, NodeFragment source) throws SmooksException {
        BeanContext beanRepository = executionContext.getBeanContext();
        HashMap<String, Map> beanMapClone = new HashMap<String, Map>(beanRepository.getBeanMap());
        try {
            List resultSet = (List)beanRepository.getBean(this.resultSetBeanId);
            if (resultSet == null) {
                throw new SmooksException("Resultset '" + this.resultSetName + "' not found in bean context.  Make sure an appropriate SQLExecutor resource config wraps this selector config.");
            }
            try {
                Map selectedRow = null;
                Iterator resultIter = resultSet.iterator();
                while (selectedRow == null && resultIter.hasNext()) {
                    Map row = (Map)resultIter.next();
                    beanMapClone.put("row", row);
                    if (!this.whereEvaluator.eval(beanMapClone)) continue;
                    selectedRow = row;
                    beanRepository.addBean(this.beanIdObj, (Object)selectedRow, (Fragment)source);
                }
                if (selectedRow == null && this.failedSelectError.isPresent()) {
                    throw new DataSelectionException(this.failedSelectError.get().apply((Object)beanRepository.getBeanMap()));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Selected resultset where '" + this.whereEvaluator.getExpression() + "': [" + selectedRow + "].");
                }
            }
            catch (ClassCastException e) {
                throw new SmooksException("Bean '" + this.resultSetName + "' cannot be used as a Reference Data resultset.  The resultset List must contain entries of type Map<String, Object>.");
            }
        }
        catch (ClassCastException e) {
            throw new SmooksException("Bean '" + this.resultSetName + "' cannot be used as a Reference Data resultset.  A resultset must be of type List<Map<String, Object>>. '" + this.resultSetName + "' is of type '" + beanRepository.getBean(this.resultSetBeanId).getClass().getName() + "'.");
        }
    }
}

