/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.resource.visitor.VisitAfterIf;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeIf;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.routing.db.ResultSetScope;
import org.smooks.cartridges.routing.db.StatementExec;
import org.smooks.cartridges.routing.db.StatementType;
import org.smooks.engine.db.AbstractDataSource;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.support.CollectionsUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeIf(condition="executeBefore")
@VisitAfterIf(condition="!executeBefore")
@VisitBeforeReport(summary="Execute statement '${resource.parameters.statement}' on Datasource '${resource.parameters.datasource}'.", detailTemplate="reporting/SQLExecutor.html")
@VisitAfterReport(summary="Execute statement '${resource.parameters.statement}' on Datasource '${resource.parameters.datasource}'.", detailTemplate="reporting/SQLExecutor.html")
public class SQLExecutor
implements BeforeVisitor,
AfterVisitor,
Producer,
Consumer {
    @Inject
    private String datasource;
    @Inject
    private String statement;
    private StatementExec statementExec;
    private String rsAppContextKey;
    @Inject
    private Optional<String> resultSetName;
    @Inject
    private ResultSetScope resultSetScope = ResultSetScope.EXECUTION;
    @Inject
    private Long resultSetTTL = 900000L;
    @Inject
    private Boolean executeBefore = false;
    @Inject
    private ApplicationContext appContext;
    private BeanId resultSetBeanId;

    public SQLExecutor setDatasource(AbstractDataSource datasource) {
        AssertArgument.isNotNull((Object)datasource, (String)"datasource");
        this.datasource = datasource.getName();
        return this;
    }

    public SQLExecutor setStatement(String statement) {
        AssertArgument.isNotNullAndNotEmpty((String)statement, (String)"statement");
        this.statement = statement;
        return this;
    }

    public SQLExecutor setResultSetName(String resultSetName) {
        AssertArgument.isNotNullAndNotEmpty((String)resultSetName, (String)"resultSetName");
        this.resultSetName = Optional.of(resultSetName);
        return this;
    }

    public String getResultSetName() {
        return this.resultSetName.orElse(null);
    }

    public SQLExecutor setResultSetScope(ResultSetScope resultSetScope) {
        AssertArgument.isNotNull((Object)((Object)resultSetScope), (String)"resultSetScope");
        this.resultSetScope = resultSetScope;
        return this;
    }

    public SQLExecutor setResultSetTTL(long resultSetTTL) {
        this.resultSetTTL = resultSetTTL;
        return this;
    }

    public SQLExecutor setExecuteBefore(boolean executeBefore) {
        this.executeBefore = executeBefore;
        return this;
    }

    public boolean getExecuteBefore() {
        return this.executeBefore;
    }

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        this.statementExec = new StatementExec(this.statement);
        if (this.statementExec.getStatementType() == StatementType.QUERY && !this.resultSetName.isPresent()) {
            throw new SmooksConfigException("Sorry, query statements must be accompanied by a 'resultSetName' property, under whose value the query results are bound.");
        }
        if (this.resultSetName.isPresent()) {
            this.resultSetBeanId = this.appContext.getBeanIdStore().register(this.resultSetName.get());
        }
        this.rsAppContextKey = this.datasource + ":" + this.statement;
    }

    public Set<?> getProducts() {
        if (this.statementExec.getStatementType() == StatementType.QUERY) {
            return CollectionsUtil.toSet((Object[])new Optional[]{this.resultSetName});
        }
        return CollectionsUtil.toSet((Object[])new Object[0]);
    }

    public boolean consumes(Object object) {
        return this.statement.contains(object.toString());
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.executeSQL(executionContext, new NodeFragment((Node)element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.executeSQL(executionContext, new NodeFragment((Node)element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(ExecutionContext executionContext, NodeFragment source) throws SmooksException {
        block15: {
            Connection connection = AbstractDataSource.getConnection((String)this.datasource, (ExecutionContext)executionContext);
            BeanContext beanContext = executionContext.getBeanContext();
            Map beanMap = beanContext.getBeanMap();
            try {
                if (!this.statementExec.isJoin()) {
                    if (this.statementExec.getStatementType() == StatementType.QUERY) {
                        if (this.resultSetScope == ResultSetScope.EXECUTION) {
                            beanContext.addBean(this.resultSetBeanId, this.statementExec.executeUnjoinedQuery(connection, new Object[0]), (Fragment)source);
                            break block15;
                        }
                        ApplicationContext appContext = executionContext.getApplicationContext();
                        ResultSetContextObject rsContextObj = ResultSetContextObject.getInstance(this.rsAppContextKey, appContext);
                        if (rsContextObj.hasExpired()) {
                            ResultSetContextObject resultSetContextObject = rsContextObj;
                            synchronized (resultSetContextObject) {
                                if (rsContextObj.hasExpired()) {
                                    rsContextObj.resultSet = this.statementExec.executeUnjoinedQuery(connection, new Object[0]);
                                    rsContextObj.expiresAt = System.currentTimeMillis() + this.resultSetTTL;
                                }
                            }
                        }
                        List resultMap = rsContextObj.resultSet;
                        beanContext.addBean(this.resultSetBeanId, (Object)resultMap, (Fragment)source);
                        break block15;
                    }
                    this.statementExec.executeUnjoinedUpdate(connection, new Object[0]);
                    break block15;
                }
                if (this.statementExec.getStatementType() == StatementType.QUERY) {
                    ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
                    this.statementExec.executeJoinedQuery(connection, beanMap, resultMap);
                    beanContext.addBean(this.resultSetBeanId, resultMap, (Fragment)source);
                    break block15;
                }
                if (this.resultSetBeanId == null) {
                    this.statementExec.executeJoinedUpdate(connection, beanMap);
                    break block15;
                }
                Object resultSetObj = beanContext.getBean(this.resultSetBeanId);
                if (resultSetObj != null) {
                    try {
                        List resultSet = (List)resultSetObj;
                        this.statementExec.executeJoinedStatement(connection, resultSet);
                        break block15;
                    }
                    catch (ClassCastException e) {
                        throw new SmooksException("Cannot execute joined statement '" + this.statementExec.getStatement() + "' on ResultSet '" + this.resultSetName + "'.  Must be of type 'List<Map<String, Object>>'.  Is of type '" + resultSetObj.getClass().getName() + "'.");
                    }
                }
                throw new SmooksException("Cannot execute joined statement '" + this.statementExec.getStatement() + "' on ResultSet '" + this.resultSetName + "'.  ResultSet not found in ExecutionContext.");
            }
            catch (SQLException e) {
                throw new SmooksException("Error executing SQL Statement '" + this.statement + "'.", (Throwable)e);
            }
        }
    }

    private static class ResultSetContextObject {
        private List<Map<String, Object>> resultSet;
        private long expiresAt = 0L;

        private ResultSetContextObject() {
        }

        private boolean hasExpired() {
            return this.expiresAt <= System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ResultSetContextObject getInstance(String rsAppContextKey, ApplicationContext appContext) {
            ResultSetContextObject rsContextObj = (ResultSetContextObject)appContext.getRegistry().lookup((Object)rsAppContextKey);
            if (rsContextObj == null) {
                ApplicationContext applicationContext = appContext;
                synchronized (applicationContext) {
                    rsContextObj = (ResultSetContextObject)appContext.getRegistry().lookup((Object)rsAppContextKey);
                    if (rsContextObj == null) {
                        rsContextObj = new ResultSetContextObject();
                        appContext.getRegistry().registerObject((Object)rsAppContextKey, (Object)rsContextObj);
                    }
                }
            }
            return rsContextObj;
        }
    }
}

