/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.jms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AcknowledgeModeEnum {
    CLIENT_ACKNOWLEDGE(2),
    AUTO_ACKNOWLEDGE(1),
    DUPS_OK_ACKNOWLEDGE(3);

    private static final Logger LOGGER;
    private int jmsAckModeInt;

    private AcknowledgeModeEnum(int jmsAckModeInt) {
        this.jmsAckModeInt = jmsAckModeInt;
    }

    public int getAcknowledgeModeInt() {
        return this.jmsAckModeInt;
    }

    public static AcknowledgeModeEnum getAckMode(String ackMode) {
        if (ackMode != null) {
            try {
                return AcknowledgeModeEnum.valueOf(ackMode);
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("' " + ackMode + "' is invalid : . Will use default '" + (Object)((Object)AUTO_ACKNOWLEDGE));
            }
        }
        return AUTO_ACKNOWLEDGE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(AcknowledgeModeEnum.class);
    }
}

