/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.jms;

import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.resource.visitor.VisitAfterIf;
import org.smooks.api.resource.visitor.VisitBeforeIf;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.routing.SmooksRoutingException;
import org.smooks.cartridges.routing.jms.AckMode;
import org.smooks.cartridges.routing.jms.AcknowledgeModeEnum;
import org.smooks.cartridges.routing.jms.DeliveryMode;
import org.smooks.cartridges.routing.jms.JMSProperties;
import org.smooks.cartridges.routing.jms.JNDIProperties;
import org.smooks.cartridges.routing.jms.message.creationstrategies.MessageCreationStrategy;
import org.smooks.cartridges.routing.jms.message.creationstrategies.StrategyFactory;
import org.smooks.cartridges.routing.jms.message.creationstrategies.TextMessageCreationStrategy;
import org.smooks.support.FreeMarkerTemplate;
import org.smooks.support.FreeMarkerUtils;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="executeBefore")
@VisitAfterIf(condition="!executeBefore")
public class JMSRouter
implements BeforeVisitor,
AfterVisitor,
Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSRouter.class);
    private final JNDIProperties jndiProperties = new JNDIProperties();
    private final JMSProperties jmsProperties = new JMSProperties();
    @Inject
    private String beanId;
    @Inject
    private Optional<String> correlationIdPattern;
    private FreeMarkerTemplate correlationIdTemplate;
    @Inject
    private Integer highWaterMark = 200;
    @Inject
    private Long highWaterMarkTimeout = 60000L;
    @Inject
    private Long highWaterMarkPollFrequency = 1000L;
    @Inject
    private Boolean executeBefore = false;
    private MessageCreationStrategy msgCreationStrategy = new TextMessageCreationStrategy();
    private Destination destination;
    private Connection connection;
    private MessageProducer msgProducer;
    private Session session;

    @PostConstruct
    public void initialize() throws SmooksConfigException, JMSException {
        Context context = null;
        boolean initialized = false;
        if (this.beanId == null) {
            throw new SmooksConfigException("Mandatory 'beanId' property not defined.");
        }
        if (this.jmsProperties.getDestinationName() == null) {
            throw new SmooksConfigException("Mandatory 'destinationName' property not defined.");
        }
        try {
            this.correlationIdPattern.ifPresent(s -> {
                this.correlationIdTemplate = new FreeMarkerTemplate(s);
            });
            Properties jndiContextProperties = this.jndiProperties.toProperties();
            context = jndiContextProperties.isEmpty() ? new InitialContext() : new InitialContext(jndiContextProperties);
            this.destination = (Destination)context.lookup(this.jmsProperties.getDestinationName());
            this.msgProducer = this.createMessageProducer(this.destination, context);
            this.setMessageProducerProperties();
            initialized = true;
        }
        catch (NamingException e) {
            String errorMsg = "NamingException while trying to lookup [" + this.jmsProperties.getDestinationName() + "]";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new SmooksConfigException(errorMsg, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    LOGGER.debug("NamingException while trying to close initial Context");
                }
            }
            if (!initialized) {
                this.releaseJMSResources();
            }
        }
    }

    @PreDestroy
    public void preDestroy() throws JMSException {
        this.releaseJMSResources();
    }

    public boolean consumes(Object object) {
        return object.toString().startsWith(this.beanId);
    }

    public void setBeanId(String beanId) {
        AssertArgument.isNotNullAndNotEmpty((String)beanId, (String)"beanId");
        this.beanId = beanId;
    }

    public void setCorrelationIdPattern(String correlationIdPattern) {
        this.correlationIdPattern = Optional.ofNullable(correlationIdPattern);
    }

    public void setHighWaterMark(int highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    public void setHighWaterMarkTimeout(long highWaterMarkTimeout) {
        this.highWaterMarkTimeout = highWaterMarkTimeout;
    }

    public void setHighWaterMarkPollFrequency(long highWaterMarkPollFrequency) {
        this.highWaterMarkPollFrequency = highWaterMarkPollFrequency;
    }

    @Inject
    public void setJndiContextFactory(Optional<String> contextFactory) {
        this.jndiProperties.setContextFactory(contextFactory.orElse(null));
    }

    @Inject
    public void setJndiProperties(Optional<String> propertiesFile) {
        this.jndiProperties.setPropertiesFile(propertiesFile.orElse(null));
    }

    public void setJndiProperties(Properties properties) {
        this.jndiProperties.setProperties(properties);
    }

    @Inject
    public void setJndiProviderUrl(Optional<String> providerUrl) {
        this.jndiProperties.setProviderUrl(providerUrl.orElse(null));
    }

    @Inject
    public void setJndiNamingFactoryUrl(Optional<String> pkgUrl) {
        this.jndiProperties.setNamingFactoryUrlPkgs(pkgUrl.orElse(null));
    }

    @Inject
    public void setDestinationName(String destinationName) {
        AssertArgument.isNotNullAndNotEmpty((String)destinationName, (String)"destinationName");
        this.jmsProperties.setDestinationName(destinationName);
    }

    @Inject
    public void setDeliveryMode(Optional<DeliveryMode> deliveryMode) {
        this.jmsProperties.setDeliveryMode(deliveryMode.orElse(DeliveryMode.PERSISTENT).toString());
    }

    @Inject
    public void setTimeToLive(Optional<Long> timeToLive) {
        this.jmsProperties.setTimeToLive(timeToLive.orElse(0L));
    }

    @Inject
    public void setSecurityPrincipal(Optional<String> securityPrincipal) {
        this.jmsProperties.setSecurityPrincipal(securityPrincipal.orElse(null));
    }

    @Inject
    public void setSecurityCredential(Optional<String> securityCredential) {
        this.jmsProperties.setSecurityCredential(securityCredential.orElse(null));
    }

    @Inject
    public void setTransacted(Optional<Boolean> transacted) {
        this.jmsProperties.setTransacted(transacted.orElse(false));
    }

    @Inject
    public void setConnectionFactoryName(Optional<String> connectionFactoryName) {
        this.jmsProperties.setConnectionFactoryName(connectionFactoryName.orElse("ConnectionFactory"));
    }

    @Inject
    public void setPriority(Optional<Integer> priority) {
        this.jmsProperties.setPriority(priority.orElse(0));
    }

    @Inject
    public void setAcknowledgeMode(Optional<AckMode> jmsAcknowledgeMode) {
        this.jmsProperties.setAcknowledgeMode(jmsAcknowledgeMode.orElse(AckMode.DUPS_OK_ACKNOWLEDGE).toString());
    }

    @Inject
    public void setMessageType(Optional<StrategyFactory.StrategyFactoryEnum> messageType) {
        this.msgCreationStrategy = StrategyFactory.getInstance().createStrategy(messageType.orElse(StrategyFactory.StrategyFactoryEnum.TEXT_MESSAGE).toString());
        this.jmsProperties.setMessageType(messageType.orElse(StrategyFactory.StrategyFactoryEnum.TEXT_MESSAGE).toString());
    }

    public Boolean getExecuteBefore() {
        return this.executeBefore;
    }

    public void visitAfter(Element element, ExecutionContext execContext) throws SmooksException {
        this.visit(execContext);
    }

    public void visitBefore(Element element, ExecutionContext execContext) throws SmooksException {
        this.visit(execContext);
    }

    private void visit(ExecutionContext execContext) throws SmooksException {
        Message message = this.msgCreationStrategy.createJMSMessage(this.beanId, execContext, this.session);
        if (this.correlationIdTemplate != null) {
            this.setCorrelationID(execContext, message);
        }
        this.sendMessage(message);
    }

    protected MessageProducer createMessageProducer(Destination destination, Context context) throws JMSException {
        try {
            ConnectionFactory connFactory = (ConnectionFactory)context.lookup(this.jmsProperties.getConnectionFactoryName());
            this.connection = this.jmsProperties.getSecurityPrincipal() == null && this.jmsProperties.getSecurityCredential() == null ? connFactory.createConnection() : connFactory.createConnection(this.jmsProperties.getSecurityPrincipal(), this.jmsProperties.getSecurityCredential());
            this.session = this.connection.createSession(this.jmsProperties.isTransacted(), AcknowledgeModeEnum.getAckMode(this.jmsProperties.getAcknowledgeMode().toUpperCase()).getAcknowledgeModeInt());
            this.msgProducer = this.session.createProducer(destination);
            this.connection.start();
            LOGGER.info("JMS Connection started");
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to create MessageProducer for Queue [" + this.jmsProperties.getDestinationName() + "]";
            this.releaseJMSResources();
            throw new SmooksConfigException(errorMsg, (Throwable)e);
        }
        catch (NamingException e) {
            String errorMsg = "NamingException while trying to lookup ConnectionFactory [" + this.jmsProperties.getConnectionFactoryName() + "]";
            this.releaseJMSResources();
            throw new SmooksConfigException(errorMsg, (Throwable)e);
        }
        return this.msgProducer;
    }

    protected void setMessageProducerProperties() throws SmooksConfigException {
        try {
            this.msgProducer.setTimeToLive(this.jmsProperties.getTimeToLive());
            this.msgProducer.setPriority(this.jmsProperties.getPriority());
            int deliveryModeInt = "non-persistent".equals(this.jmsProperties.getDeliveryMode()) ? 1 : 2;
            this.msgProducer.setDeliveryMode(deliveryModeInt);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to set JMS Header Fields";
            throw new SmooksConfigException("JMSException while trying to set JMS Header Fields", (Throwable)e);
        }
    }

    protected void sendMessage(Message message) throws SmooksRoutingException {
        try {
            this.waitWhileAboveHighWaterMark();
        }
        catch (JMSException e) {
            throw new SmooksRoutingException("Exception while attempting to check JMS Queue High Water Mark.", e);
        }
        try {
            this.msgProducer.send(message);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while sending Message.";
            throw new SmooksRoutingException("JMSException while sending Message.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileAboveHighWaterMark() throws JMSException, SmooksRoutingException {
        if (this.highWaterMark == -1) {
            return;
        }
        if (this.session instanceof QueueSession) {
            QueueSession queueSession = (QueueSession)this.session;
            try (QueueBrowser queueBrowser = queueSession.createBrowser((Queue)this.destination);){
                int length = this.getQueueLength(queueBrowser);
                long start = System.currentTimeMillis();
                if (LOGGER.isDebugEnabled() && length >= this.highWaterMark) {
                    LOGGER.debug("Length of JMS destination Queue '" + this.jmsProperties.getDestinationName() + "' has reached " + length + ".  High Water Mark is " + this.highWaterMark + ".  Waiting for Queue length to drop.");
                }
                while (length >= this.highWaterMark && System.currentTimeMillis() < start + this.highWaterMarkTimeout) {
                    try {
                        Thread.sleep(this.highWaterMarkPollFrequency);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Interrupted", (Throwable)e);
                        queueBrowser.close();
                        return;
                    }
                    length = this.getQueueLength(queueBrowser);
                }
                if (length >= this.highWaterMark) {
                    throw new SmooksRoutingException("Failed to route JMS message to Queue destination '" + ((Queue)this.destination).getQueueName() + "'. Timed out (" + this.highWaterMarkTimeout + " ms) waiting for queue length to drop below High Water Mark (" + this.highWaterMark + ").  Consider increasing 'highWaterMark' and/or 'highWaterMarkTimeout' param values.");
                }
            }
        }
    }

    private int getQueueLength(QueueBrowser queueBrowser) throws JMSException {
        int length = 0;
        Enumeration queueEnum = queueBrowser.getEnumeration();
        while (queueEnum.hasMoreElements()) {
            ++length;
            queueEnum.nextElement();
        }
        return length;
    }

    protected void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (JMSException e) {
                String errorMsg = "JMSException while trying to close connection";
                LOGGER.debug("JMSException while trying to close connection", (Throwable)e);
            }
        }
    }

    protected void close(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException e) {
                String errorMsg = "JMSException while trying to close session";
                LOGGER.debug("JMSException while trying to close session", (Throwable)e);
            }
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public String getJndiContextFactory() {
        return this.jndiProperties.getContextFactory();
    }

    public String getJndiProviderUrl() {
        return this.jndiProperties.getProviderUrl();
    }

    public String getJndiNamingFactoryUrl() {
        return this.jndiProperties.getNamingFactoryUrlPkgs();
    }

    public String getDestinationName() {
        return this.jmsProperties.getDestinationName();
    }

    private void setCorrelationID(ExecutionContext execContext, Message message) {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)execContext);
        String correlationId = this.correlationIdTemplate.apply((Object)beanMap);
        try {
            message.setJMSCorrelationID(correlationId);
        }
        catch (JMSException e) {
            throw new SmooksException("Failed to set CorrelationID '" + correlationId + "' on message.", (Throwable)e);
        }
    }

    public String getDeliveryMode() {
        return this.jmsProperties.getDeliveryMode();
    }

    public long getTimeToLive() {
        return this.jmsProperties.getTimeToLive();
    }

    public String getSecurityPrincipal() {
        return this.jmsProperties.getSecurityPrincipal();
    }

    public String getSecurityCredential() {
        return this.jmsProperties.getSecurityCredential();
    }

    public boolean isTransacted() {
        return this.jmsProperties.isTransacted();
    }

    public String getConnectionFactoryName() {
        return this.jmsProperties.getConnectionFactoryName();
    }

    public int getPriority() {
        return this.jmsProperties.getPriority();
    }

    public String getAcknowledgeMode() {
        return this.jmsProperties.getAcknowledgeMode();
    }

    public void setMsgCreationStrategy(MessageCreationStrategy msgCreationStrategy) {
        this.msgCreationStrategy = msgCreationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJMSResources() throws JMSException {
        if (this.connection != null) {
            try {
                try {
                    this.connection.stop();
                }
                finally {
                    try {
                        this.closeProducer();
                    }
                    finally {
                        this.closeSession();
                    }
                }
            }
            catch (JMSException e) {
                LOGGER.debug("JMSException while trying to stop JMS Connection.", (Throwable)e);
            }
            finally {
                this.connection.close();
                this.connection = null;
            }
        }
    }

    private void closeProducer() {
        if (this.msgProducer != null) {
            try {
                this.msgProducer.close();
            }
            catch (JMSException e) {
                LOGGER.debug("JMSException while trying to close JMS Message Producer.", (Throwable)e);
            }
            finally {
                this.msgProducer = null;
            }
        }
    }

    private void closeSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                LOGGER.debug("JMSException while trying to close JMS Session.", (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
    }
}

