/*-
 * ========================LICENSE_START=================================
 * smooks-routing-cartridge
 * %%
 * Copyright (C) 2020 Smooks
 * %%
 * Licensed under the terms of the Apache License Version 2.0, or
 * the GNU Lesser General Public License version 3.0 or later.
 * 
 * SPDX-License-Identifier: Apache-2.0 OR LGPL-3.0-or-later
 * 
 * ======================================================================
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * ======================================================================
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * =========================LICENSE_END==================================
 */
package org.smooks.cartridges.routing.jms;

import org.smooks.cartridges.routing.jms.message.creationstrategies.StrategyFactory;

import javax.jms.Message;

/**
 * Class to hold JMS properties
 *
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>
 *
 */
public class JMSProperties
{
    private String connectionFactoryName = "ConnectionFactory";
    private String destinationName;
    private String deliveryMode = "persistent";
    private int priority = Message.DEFAULT_PRIORITY;
    private long timeToLive = Message.DEFAULT_TIME_TO_LIVE;
    private String securityPrincipal;
    private String securityCredential;
    private boolean transacted = false;
    private String jmsAcknowledgeMode = "AUTO_ACKNOWLEDGE";
    private String messageType = StrategyFactory.TEXT_MESSAGE;

	public String getConnectionFactoryName()
	{
		return connectionFactoryName;
	}
	public void setConnectionFactoryName( String connectionFactoryName )
	{
		this.connectionFactoryName = connectionFactoryName;
	}
	public String getDestinationName()
	{
		return destinationName;
	}
	public void setDestinationName( String destinationName )
	{
		this.destinationName = destinationName;
	}
	public String getDeliveryMode()
	{
		return deliveryMode;
	}
	public void setDeliveryMode( String deliveryMode )
	{
		this.deliveryMode = deliveryMode;
	}
	public int getPriority()
	{
		return priority;
	}
	public void setPriority( int priority )
	{
		this.priority = priority;
	}
	public long getTimeToLive()
	{
		return timeToLive;
	}
	public void setTimeToLive( long timeToLive )
	{
		this.timeToLive = timeToLive;
	}
	public String getSecurityPrincipal()
	{
		return securityPrincipal;
	}
	public void setSecurityPrincipal( String securityPrincipal )
	{
		this.securityPrincipal = securityPrincipal;
	}
	public String getSecurityCredential()
	{
		return securityCredential;
	}
	public void setSecurityCredential( String securityCredential )
	{
		this.securityCredential = securityCredential;
	}
	public boolean isTransacted()
	{
		return transacted;
	}
	public void setTransacted( boolean transacted )
	{
		this.transacted = transacted;
	}
	public String getAcknowledgeMode()
	{
		return jmsAcknowledgeMode;
	}
	public void setAcknowledgeMode( String jmsAcknowledgeMode )
	{
		this.jmsAcknowledgeMode = jmsAcknowledgeMode;
	}
	public String getMessageType()
	{
		return messageType;
	}
	public void setMessageType( String messageType )
	{
		this.messageType = messageType;
	}

}
