/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.file;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.smooks.api.ExecutionContext;
import org.smooks.api.TypedKey;
import org.smooks.assertion.AssertArgument;

public class FileListAccessor {
    private static final TypedKey<List<String>> ALL_LIST_FILE_NAME_CONTEXT_KEY = new TypedKey();

    private FileListAccessor() {
    }

    public static void addFileName(String fileName, ExecutionContext execContext) {
        AssertArgument.isNotNullAndNotEmpty((String)fileName, (String)"fileName");
        ArrayList<String> allListFiles = (ArrayList<String>)execContext.get(ALL_LIST_FILE_NAME_CONTEXT_KEY);
        if (allListFiles == null) {
            allListFiles = new ArrayList<String>();
        }
        if (!allListFiles.contains(fileName)) {
            allListFiles.add(fileName);
        }
        execContext.put(ALL_LIST_FILE_NAME_CONTEXT_KEY, allListFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFileList(ExecutionContext executionContext, String fromFile) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(fromFile));
            ArrayList<String> files = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                files.add(line);
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    public static List<String> getListFileNames(ExecutionContext executionContext) {
        return (List)executionContext.get(ALL_LIST_FILE_NAME_CONTEXT_KEY);
    }

    public static List<String> getListFileNames(Map attributes) {
        return (List)attributes.get(ALL_LIST_FILE_NAME_CONTEXT_KEY);
    }
}

