/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.routing.SmooksRoutingException;
import org.smooks.cartridges.routing.file.FileListAccessor;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.io.AbstractOutputStreamResource;
import org.smooks.support.DollarBraceDecoder;
import org.smooks.support.FreeMarkerTemplate;
import org.smooks.support.FreeMarkerUtils;

public class FileOutputStreamResource
extends AbstractOutputStreamResource {
    private static final String TMP_FILE_CONTEXT_KEY_PREFIX = FileOutputStreamResource.class.getName() + "#tmpFile:";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Object LOCK = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(FileOutputStreamResource.class);
    @Inject
    private String fileNamePattern;
    private FreeMarkerTemplate fileNameTemplate;
    @Inject
    private String destinationDirectoryPattern;
    private FreeMarkerTemplate destinationDirectoryTemplate;
    private FileFilter fileFilter;
    @Inject
    private Optional<String> listFileNamePattern;
    private FreeMarkerTemplate listFileNameTemplate;
    @Inject
    private Boolean append = false;
    private String listFileNamePatternCtxKey;
    @Inject
    private Integer highWaterMark = 200;
    @Inject
    private Long highWaterMarkTimeout = 60000L;
    @Inject
    private Long highWaterMarkPollFrequency = 1000L;
    @Inject
    private Optional<ExpressionEvaluator> closeOnCondition;

    public FileOutputStreamResource setFileNamePattern(String fileNamePattern) {
        AssertArgument.isNotNullAndNotEmpty((String)fileNamePattern, (String)"fileNamePattern");
        this.fileNamePattern = fileNamePattern;
        return this;
    }

    public FileOutputStreamResource setDestinationDirectoryPattern(String destinationDirectoryPattern) {
        AssertArgument.isNotNullAndNotEmpty((String)destinationDirectoryPattern, (String)"destinationDirectoryPattern");
        this.destinationDirectoryPattern = destinationDirectoryPattern;
        return this;
    }

    public FileOutputStreamResource setListFileNamePattern(String listFileNamePattern) {
        AssertArgument.isNotNullAndNotEmpty((String)listFileNamePattern, (String)"listFileNamePattern");
        this.listFileNamePattern = Optional.of(listFileNamePattern);
        return this;
    }

    public FileOutputStreamResource setListFileNamePatternCtxKey(String listFileNamePatternCtxKey) {
        AssertArgument.isNotNullAndNotEmpty((String)listFileNamePatternCtxKey, (String)"listFileNamePatternCtxKey");
        this.listFileNamePatternCtxKey = listFileNamePatternCtxKey;
        return this;
    }

    public FileOutputStreamResource setHighWaterMark(int highWaterMark) {
        this.highWaterMark = highWaterMark;
        return this;
    }

    public FileOutputStreamResource setHighWaterMarkTimeout(long highWaterMarkTimeout) {
        this.highWaterMarkTimeout = highWaterMarkTimeout;
        return this;
    }

    public FileOutputStreamResource setHighWaterMarkPollFrequency(long highWaterMarkPollFrequency) {
        this.highWaterMarkPollFrequency = highWaterMarkPollFrequency;
        return this;
    }

    public void setCloseOnCondition(String closeOnCondition) {
        AssertArgument.isNotNullAndNotEmpty((String)closeOnCondition, (String)"closeOnCondition");
        this.closeOnCondition = Optional.of(new MVELExpressionEvaluator());
        this.closeOnCondition.get().setExpression(closeOnCondition);
    }

    public FileOutputStreamResource setAppend(boolean append) {
        this.append = append;
        return this;
    }

    @PostConstruct
    public void initialize() throws SmooksConfigException {
        if (this.fileNamePattern == null) {
            throw new SmooksConfigException("Null 'fileNamePattern' configuration parameter.");
        }
        if (this.destinationDirectoryPattern == null) {
            throw new SmooksConfigException("Null 'destinationDirectoryPattern' configuration parameter.");
        }
        this.fileNameTemplate = new FreeMarkerTemplate(this.fileNamePattern);
        this.destinationDirectoryTemplate = new FreeMarkerTemplate(this.destinationDirectoryPattern);
        this.fileFilter = new SplitFilenameFilter(this.fileNamePattern);
        if (this.listFileNamePattern.isPresent()) {
            this.listFileNameTemplate = new FreeMarkerTemplate(this.listFileNamePattern.get());
            this.listFileNamePatternCtxKey = FileOutputStreamResource.class.getName() + "#" + this.listFileNamePattern;
        }
    }

    public FileOutputStream getOutputStream(ExecutionContext executionContext) throws SmooksRoutingException, IOException {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext);
        String destinationDirName = this.destinationDirectoryTemplate.apply((Object)beanMap);
        File destinationDirectory = new File(destinationDirName);
        this.assertTargetDirectoryOK(destinationDirectory);
        this.waitWhileAboveHighWaterMark(destinationDirectory);
        if (this.append.booleanValue()) {
            File outputFile = new File(destinationDirectory, this.getOutputFileName(executionContext));
            return new FileOutputStream(outputFile, true);
        }
        File tmpFile = File.createTempFile("." + UUID.randomUUID().toString(), ".working", destinationDirectory);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile, false);
        executionContext.put(new TypedKey(TMP_FILE_CONTEXT_KEY_PREFIX + this.getResourceName()), (Object)tmpFile);
        return fileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertTargetDirectoryOK(File destinationDirectory) throws SmooksRoutingException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new SmooksRoutingException("The file routing target directory '" + destinationDirectory.getAbsolutePath() + "' exist but is not a directory. destinationDirectoryPattern: '" + this.destinationDirectoryPattern + "'");
        }
        if (!destinationDirectory.exists()) {
            Object object = LOCK;
            synchronized (object) {
                if (!(destinationDirectory.exists() || destinationDirectory.mkdirs() || destinationDirectory.exists() && destinationDirectory.isDirectory())) {
                    throw new SmooksRoutingException("Failed to create file routing target directory '" + destinationDirectory.getAbsolutePath() + "'. destinationDirectoryPattern: '" + this.destinationDirectoryPattern + "'");
                }
            }
        }
    }

    private void waitWhileAboveHighWaterMark(File destinationDirectory) throws SmooksRoutingException {
        if (this.highWaterMark == -1) {
            return;
        }
        File[] currentList = destinationDirectory.listFiles(this.fileFilter);
        if (currentList.length >= this.highWaterMark) {
            long start = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Destination directoy '" + destinationDirectory.getAbsolutePath() + "' contains " + currentList.length + " file matching pattern '" + this.listFileNamePattern + "'.  High Water Mark is " + this.highWaterMark + ".  Waiting for file count to drop.");
            }
            while (System.currentTimeMillis() < start + this.highWaterMarkTimeout) {
                try {
                    Thread.sleep(this.highWaterMarkPollFrequency);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted", (Throwable)e);
                    return;
                }
                currentList = destinationDirectory.listFiles(this.fileFilter);
                if (currentList.length >= this.highWaterMark) continue;
                return;
            }
            throw new SmooksRoutingException("Failed to route message to Filesystem destination '" + destinationDirectory.getAbsolutePath() + "'. Timed out (" + this.highWaterMarkTimeout + " ms) waiting for the number of '" + this.listFileNamePattern + "' files to drop below High Water Mark (" + this.highWaterMark + ").  Consider increasing 'highWaterMark' and/or 'highWaterMarkTimeout' param values.");
        }
    }

    protected boolean closeCondition(ExecutionContext executionContext) {
        return this.closeOnCondition.map(expressionEvaluator -> expressionEvaluator.eval((Object)executionContext.getBeanContext().getBeanMap())).orElse(true);
    }

    protected void closeResource(ExecutionContext executionContext) {
        try {
            super.closeResource(executionContext);
        }
        finally {
            File newFile;
            if (!this.append.booleanValue() && (newFile = this.renameWorkingFile(executionContext)) != null) {
                this.addToListFile(executionContext, newFile);
            }
        }
    }

    private File renameWorkingFile(ExecutionContext executionContext) {
        File workingFile = (File)executionContext.get(new TypedKey(TMP_FILE_CONTEXT_KEY_PREFIX + this.getResourceName()));
        if (workingFile == null || !workingFile.exists()) {
            return null;
        }
        String newFileName = this.getOutputFileName(executionContext);
        File newFile = new File(workingFile.getParentFile(), newFileName);
        if (newFile.exists()) {
            throw new SmooksException("Could not rename [" + workingFile.getAbsolutePath() + "] to [" + newFile.getAbsolutePath() + "]. [" + newFile.getAbsolutePath() + "] already exists.");
        }
        boolean renameTo = workingFile.renameTo(newFile);
        if (!renameTo) {
            throw new SmooksException("Could not rename [" + workingFile.getAbsolutePath() + "] to [" + newFile.getAbsolutePath() + "]");
        }
        workingFile.delete();
        return newFile;
    }

    private String getOutputFileName(ExecutionContext executionContext) {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext);
        return this.fileNameTemplate.apply((Object)beanMap);
    }

    private void addToListFile(ExecutionContext executionContext, File newFile) {
        if (this.listFileNamePatternCtxKey != null) {
            FileWriter writer = (FileWriter)executionContext.get(new TypedKey(this.listFileNamePatternCtxKey));
            if (writer == null) {
                String listFileName = this.getListFileName(executionContext);
                File listFile = new File(newFile.getParentFile(), listFileName);
                FileListAccessor.addFileName(listFile.getAbsolutePath(), executionContext);
                try {
                    writer = new FileWriter(listFile);
                    executionContext.put(new TypedKey(this.listFileNamePatternCtxKey), (Object)writer);
                }
                catch (IOException e) {
                    throw new SmooksException("", (Throwable)e);
                }
            }
            try {
                writer.write(newFile.getAbsolutePath() + LINE_SEPARATOR);
                writer.flush();
            }
            catch (IOException e) {
                throw new SmooksException("IOException while trying to write to list file [" + this.getListFileName(executionContext) + "] :", (Throwable)e);
            }
        }
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        FileWriter writer;
        super.executeExecutionLifecycleCleanup(executionContext);
        if (this.listFileNamePatternCtxKey != null && (writer = (FileWriter)executionContext.get(new TypedKey(this.listFileNamePatternCtxKey))) != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to close list file '" + this.getListFileName(executionContext) + "'.", (Throwable)e);
            }
        }
    }

    private String getListFileName(ExecutionContext executionContext) {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext);
        return this.listFileNameTemplate.apply((Object)beanMap);
    }

    public static class SplitFilenameFilter
    implements FileFilter {
        private final Pattern regexPattern;

        private SplitFilenameFilter(String filenamePattern) {
            String pattern = DollarBraceDecoder.replaceTokens((String)filenamePattern, (String)".*");
            this.regexPattern = Pattern.compile(pattern);
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.regexPattern.matcher(file.getName());
            return matcher.matches();
        }
    }
}

