/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.io;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.resource.visitor.VisitAfterIf;
import org.smooks.api.resource.visitor.VisitBeforeIf;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.io.ResourceOutputStream;
import org.w3c.dom.Element;

@VisitAfterIf(condition="!parameters.containsKey('visitBefore') || parameters.visitBefore.value != 'true'")
@VisitBeforeIf(condition="!parameters.containsKey('visitAfter') || parameters.visitAfter.value != 'true'")
public class OutputStreamRouter
implements BeforeVisitor,
AfterVisitor,
Consumer {
    @Inject
    private String resourceName;
    @Inject
    private String encoding = "UTF-8";
    @Inject
    @Named(value="beanId")
    private String beanIdName;
    private BeanId beanId;
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initialize() throws SmooksConfigException {
        this.beanId = this.applicationContext.getBeanIdStore().getBeanId(this.beanIdName);
    }

    public boolean consumes(Object object) {
        if (object.equals(this.resourceName)) {
            return true;
        }
        return object.toString().startsWith(this.beanIdName);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.write(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.write(executionContext);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    private void write(ExecutionContext executionContext) {
        Object bean = executionContext.getBeanContext().getBean(this.beanId);
        if (bean == null) {
            throw new SmooksException("A bean with id [" + this.beanId + "] was not found in the executionContext");
        }
        Object out = new ResourceOutputStream(executionContext, this.resourceName);
        try {
            if (bean instanceof String) {
                ((OutputStream)out).write(((String)bean).getBytes(this.encoding));
            } else if (bean instanceof byte[]) {
                ((OutputStream)out).write(new String((byte[])bean, this.encoding).getBytes());
            } else {
                out = new ObjectOutputStream((OutputStream)out);
                ((ObjectOutputStream)out).writeObject(bean);
            }
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            String errorMsg = "IOException while trying to append to file";
            throw new SmooksException("IOException while trying to append to file", (Throwable)e);
        }
    }
}

