/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.jms.message.creationstrategies;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.cartridges.routing.jms.message.creationstrategies.MessageCreationStrategy;

public class MapMessageCreationStrategy
implements MessageCreationStrategy {
    @Override
    public Message createJMSMessage(String beanId, ExecutionContext context, Session jmsSession) throws SmooksException {
        Object bean = context.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Bean beandId '" + beanId + "' not available in the bean repository of this execution context.  Check the order in which your resources are being applied (in Smooks configuration).");
        }
        if (!(bean instanceof Map)) {
            throw new SmooksException("The bean unde beanId '" + beanId + "' with type " + bean.getClass().getName() + "'  can't be send with an JMS MapMessage because it doesn't implement a Map interface.");
        }
        return this.createMapMessage((Map)bean, jmsSession);
    }

    private MapMessage createMapMessage(Map<?, ?> map, Session jmsSession) throws SmooksException {
        try {
            MapMessage mapMessage = jmsSession.createMapMessage();
            this.mapToMapMessage(map, mapMessage);
            return mapMessage;
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to create TextMessae";
            throw new SmooksConfigException("JMSException while trying to create TextMessae", (Throwable)e);
        }
    }

    private void mapToMapMessage(Map<?, ?> map, MapMessage mapMessage) throws JMSException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof String) {
                mapMessage.setString(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                mapMessage.setInt(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                mapMessage.setLong(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                mapMessage.setDouble(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                mapMessage.setFloat(key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Boolean) {
                mapMessage.setBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Short) {
                mapMessage.setShort(key, ((Short)value).shortValue());
                continue;
            }
            if (value instanceof Byte) {
                mapMessage.setByte(key, ((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Character) {
                mapMessage.setChar(key, ((Character)value).charValue());
                continue;
            }
            if (value instanceof byte[]) {
                mapMessage.setBytes(key, (byte[])value);
                continue;
            }
            mapMessage.setString(key, value.toString());
        }
    }
}

