/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.jms.message.creationstrategies;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.cartridges.routing.jms.message.creationstrategies.MessageCreationStrategy;

public class ObjectMessageCreationStrategy
implements MessageCreationStrategy {
    @Override
    public Message createJMSMessage(String beanId, ExecutionContext context, Session jmsSession) throws SmooksException {
        Object bean = context.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Bean beandId '" + beanId + "' not available in the bean repository of this execution context.  Check the order in which your resources are being applied (in Smooks configuration).");
        }
        if (!(bean instanceof Serializable)) {
            throw new SmooksException("The bean unde beanId '" + beanId + "' with type " + bean.getClass().getName() + "'  can't be send with an JMS ObjectMessage because it isn't serializable.");
        }
        return this.createObjectMessage((Serializable)bean, jmsSession);
    }

    private ObjectMessage createObjectMessage(Serializable object, Session session) throws SmooksException {
        try {
            return session.createObjectMessage(object);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to set JMS Header Fields";
            throw new SmooksConfigException("JMSException while trying to set JMS Header Fields", (Throwable)e);
        }
    }
}

