/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.routing.jms.message.creationstrategies;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.cartridges.routing.jms.message.creationstrategies.MessageCreationStrategy;

public class TextMessageCreationStrategy
implements MessageCreationStrategy {
    @Override
    public Message createJMSMessage(String beanId, ExecutionContext context, Session jmsSession) throws SmooksException {
        Object bean = context.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Bean beandId '" + beanId + "' not available in the bean repository of this execution context.  Check the order in which your resources are being applied (in Smooks configuration).");
        }
        return this.createTextMessage(bean.toString(), jmsSession);
    }

    private TextMessage createTextMessage(String text, Session jmsSession) throws SmooksException {
        try {
            return jmsSession.createTextMessage(text);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to create TextMessae";
            throw new SmooksConfigException("JMSException while trying to create TextMessae", (Throwable)e);
        }
    }
}

