/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.rules;

import jakarta.annotation.PostConstruct;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.cartridges.rules.RuleProvider;
import org.smooks.cartridges.rules.RuleProviderAccessor;

public final class RulesProviderFactory
implements ContentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesProviderFactory.class);
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private String name;
    @Inject
    @Named(value="provider")
    private Class<RuleProvider> provider;
    @Inject
    private Optional<String> src;

    @PostConstruct
    public void installRuleProvider() throws SmooksConfigException {
        LOGGER.debug(this.toString());
        if (!RuleProvider.class.isAssignableFrom(this.provider)) {
            throw new SmooksConfigException("Invalid rule provider configuration :'" + this + "'");
        }
        RuleProvider providerImpl = this.createProvider(this.provider);
        providerImpl.setName(this.name);
        providerImpl.setSrc(this.src.orElse(null));
        RuleProviderAccessor.add(this.applicationContext, providerImpl);
    }

    RuleProvider createProvider(Class<? extends RuleProvider> providerClass) throws SmooksException {
        try {
            return providerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s [name=%s, src=%s, provider=%s]", this.getClass().getSimpleName(), this.name, this.src, this.provider);
    }
}

