/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.rules.mvel;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.cartridges.rules.RuleEvalResult;
import org.smooks.cartridges.rules.RuleProvider;
import org.smooks.cartridges.rules.mvel.MVELRuleEvalResult;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.resource.URIResourceLocator;

public class MVELProvider
implements RuleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MVELProvider.class);
    private String name;
    private String src;
    private Map<String, ExpressionEvaluator> rules = new HashMap<String, ExpressionEvaluator>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public void setSrc(String src) {
        this.src = src;
        this.loadRules();
    }

    @Override
    public RuleEvalResult evaluate(String ruleName, CharSequence selectedData, ExecutionContext context) throws SmooksException {
        ExpressionEvaluator evaluator = this.rules.get(ruleName);
        if (evaluator == null) {
            throw new SmooksException("Unknown rule name '" + ruleName + "' on MVEL RuleProvider '" + this.name + "'.");
        }
        try {
            return new MVELRuleEvalResult(evaluator.eval((Object)context.getBeanContext().getBeanMap()), ruleName, this.name, selectedData.toString());
        }
        catch (Throwable t) {
            return new MVELRuleEvalResult(t, ruleName, this.name, selectedData.toString());
        }
    }

    private void loadRules() {
        List entries;
        InputStream ruleStream;
        if (this.src == null) {
            throw new SmooksException("ruleFile not specified.");
        }
        try {
            ruleStream = new URIResourceLocator().getResource(this.src);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to open rule file '" + this.src + "'.", (Throwable)e);
        }
        CSVReader csvLineReader = new CSVReader((Reader)new InputStreamReader(ruleStream));
        try {
            entries = csvLineReader.readAll();
        }
        catch (CsvException | IOException e) {
            throw new SmooksConfigException("Error reading MVEL rule file (CSV format) '" + this.src + "'.", e);
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error closing MVEL rule file '" + this.src + "'.", (Throwable)e);
            }
        }
        for (String[] ruleLine : entries) {
            if (ruleLine.length != 2 || ruleLine[0].trim().charAt(0) == '#') continue;
            String ruleName = ruleLine[0].trim();
            String ruleExpression = ruleLine[1];
            if (this.rules.containsKey(ruleName)) {
                LOGGER.debug("Duplicate rule definition '" + ruleName + "' in MVEL rule file '" + ruleName + "'.  Ignoring duplicate.");
                continue;
            }
            this.rules.put(ruleName, new MVELExpressionEvaluator().setExpression(ruleExpression));
        }
    }
}

