/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.rules.regex;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.rules.RuleEvalResult;
import org.smooks.cartridges.rules.RuleProvider;
import org.smooks.cartridges.rules.regex.RegexRuleEvalResult;
import org.smooks.resource.URIResourceLocator;

public class RegexProvider
implements RuleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexProvider.class);
    private String src;
    private String providerName;
    private Map<String, Pattern> rules = new HashMap<String, Pattern>();

    public RegexProvider() {
    }

    public RegexProvider(String src) {
        this.setSrc(src);
    }

    @Override
    public RuleEvalResult evaluate(String ruleName, CharSequence selectedData, ExecutionContext context) throws SmooksException {
        AssertArgument.isNotNullAndNotEmpty((String)ruleName, (String)"ruleName");
        AssertArgument.isNotNull((Object)selectedData, (String)"selectedData");
        Pattern pattern = this.rules.get(ruleName);
        if (pattern == null) {
            throw new SmooksException("Unknown rule name '" + ruleName + "' on Regex RuleProvider '" + this.providerName + "'.");
        }
        boolean matched = pattern.matcher(selectedData).matches();
        return new RegexRuleEvalResult(matched, ruleName, this.providerName, pattern, selectedData.toString());
    }

    @Override
    public String getName() {
        return this.providerName;
    }

    @Override
    public void setName(String name) {
        this.providerName = name;
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public void setSrc(String src) {
        this.src = src;
        this.loadRules(src);
    }

    protected void loadRules(String ruleFile) {
        InputStream ruleStream;
        if (ruleFile == null) {
            throw new SmooksException("ruleFile not specified.");
        }
        try {
            ruleStream = new URIResourceLocator().getResource(ruleFile);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to open rule file '" + ruleFile + "'.", (Throwable)e);
        }
        Properties rawRuleTable = new Properties();
        try {
            rawRuleTable.load(ruleStream);
        }
        catch (IOException e) {
            throw new SmooksException("Error reading InputStream to rule file '" + ruleFile + "'.", (Throwable)e);
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error closing InputStream to Regex Rule file '" + ruleFile + "'.", (Throwable)e);
            }
        }
        Set<Map.Entry<Object, Object>> ruleEntrySet = rawRuleTable.entrySet();
        for (Map.Entry<Object, Object> rule : ruleEntrySet) {
            String ruleName = (String)rule.getKey();
            String rulePattern = (String)rule.getValue();
            this.rules.put(ruleName, Pattern.compile(rulePattern));
        }
    }
}

