/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.scripting.groovy;

import groovy.lang.GroovyClassLoader;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;
import org.smooks.support.FreeMarkerTemplate;
import org.smooks.support.StreamUtils;

public class GroovyContentHandlerFactory
implements ContentHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyContentHandlerFactory.class);
    private FreeMarkerTemplate classTemplate;
    private volatile int classGenCount = 1;
    @Inject
    private LifecycleManager lifecycleManager;
    @Inject
    private Registry registry;

    @PostConstruct
    public void postConstruct() throws IOException {
        String templateText = StreamUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("/script.groovy.ftl"), (String)"UTF-8");
        this.classTemplate = new FreeMarkerTemplate(templateText);
    }

    public ContentHandler create(ResourceConfig resourceConfig) throws SmooksConfigException {
        try {
            Object groovyObject;
            byte[] groovyScriptBytes = resourceConfig.getBytes();
            String groovyScript = new String(groovyScriptBytes, StandardCharsets.UTF_8);
            GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
            try {
                Class groovyClass = groovyClassLoader.parseClass(groovyScript);
                groovyObject = groovyClass.newInstance();
            }
            catch (CompilationFailedException e) {
                LOGGER.debug("Failed to create Visitor class instance directly from script:\n==========================\n" + groovyScript + "\n==========================\n Will try applying Visitor template to script.", (Throwable)e);
                groovyObject = null;
            }
            if (!(groovyObject instanceof Visitor)) {
                groovyObject = this.createFromTemplate(groovyScript, resourceConfig);
            }
            ContentHandler groovyResource = (ContentHandler)groovyObject;
            this.lifecycleManager.applyPhase((Object)groovyResource, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.registry, resourceConfig, (Object)groovyResource)));
            return groovyResource;
        }
        catch (Exception e) {
            throw new SmooksConfigException("Error constructing class from Groovy script " + resourceConfig.getResource(), (Throwable)e);
        }
    }

    public String getType() {
        return "groovy";
    }

    private Object createFromTemplate(String groovyScript, ResourceConfig resourceConfig) throws InstantiationException, IllegalAccessException {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
        HashMap<String, Object> templateVars = new HashMap<String, Object>();
        String imports = (String)resourceConfig.getParameterValue("imports", String.class, (Object)"");
        templateVars.put("imports", this.cleanImportsConfig(imports));
        templateVars.put("visitorName", this.createClassName());
        templateVars.put("elementName", this.getElementName(resourceConfig));
        templateVars.put("visitBefore", Boolean.parseBoolean((String)resourceConfig.getParameterValue("executeBefore", String.class, (Object)"false")));
        templateVars.put("visitorScript", groovyScript);
        String templatedClass = this.classTemplate.apply(templateVars);
        if (groovyScript.contains("writeFragment")) {
            resourceConfig.setParameter("writeFragment", (Object)"true");
        }
        try {
            Class groovyClass = groovyClassLoader.parseClass(templatedClass);
            return groovyClass.newInstance();
        }
        catch (CompilationFailedException e) {
            throw new SmooksConfigException("Failed to compile Groovy scripted Visitor class:\n==========================\n" + templatedClass + "\n==========================\n", (Throwable)e);
        }
    }

    private Object cleanImportsConfig(String imports) {
        try {
            StringBuffer importsBuffer = StreamUtils.trimLines((Reader)new StringReader(imports));
            imports = importsBuffer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException reading String.", e);
        }
        return imports.replace("import ", "\nimport ");
    }

    private synchronized String createClassName() {
        StringBuilder className = new StringBuilder();
        className.append("SmooksVisitor_");
        className.append(System.identityHashCode(this));
        className.append("_");
        className.append(this.classGenCount++);
        return className.toString();
    }

    private String getElementName(ResourceConfig resourceConfig) {
        if (resourceConfig.getSelectorPath() instanceof IndexedSelectorPath) {
            String elementName = ((ElementSelectorStep)((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep()).getQName().getLocalPart();
            for (int i = 0; i < elementName.length(); ++i) {
                if (Character.isLetterOrDigit(elementName.charAt(i))) continue;
                return elementName + "_Mangled";
            }
            return elementName;
        }
        throw new SmooksException("Can only get element name from org.smooks.engine.resource.config.xpath.IndexedSelectorPath");
    }
}

