/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.templating.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.cartridges.templating.AbstractTemplateProcessor;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.w3c.dom.Element;

public class StringTemplateContentHandlerFactory
implements ContentHandlerFactory<StringTemplateTemplateProcessor> {
    @Inject
    private ApplicationContext applicationContext;

    public synchronized StringTemplateTemplateProcessor create(ResourceConfig resourceConfig) throws SmooksConfigException {
        StringTemplateTemplateProcessor stringTemplateTemplateProcessor = new StringTemplateTemplateProcessor();
        try {
            ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)stringTemplateTemplateProcessor, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), resourceConfig, (Object)stringTemplateTemplateProcessor)));
            return stringTemplateTemplateProcessor;
        }
        catch (SmooksConfigException e) {
            throw e;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("StringTemplate ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.  StringTemplate resource invalid.");
            instanceException.initCause(e);
            throw new SmooksException(instanceException.getMessage(), (Throwable)instanceException);
        }
    }

    public String getType() {
        return "st";
    }

    @VisitBeforeReport(condition="false")
    @VisitAfterReport(summary="Applied StringTemplate Template.", detailTemplate="reporting/StringTemplateTemplateProcessor_After.html")
    protected static class StringTemplateTemplateProcessor
    extends AbstractTemplateProcessor
    implements Consumer {
        private StringTemplate template;

        protected StringTemplateTemplateProcessor() {
        }

        @Override
        protected void loadTemplate(ResourceConfig config) {
            String path = config.getResource();
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.endsWith(".st")) {
                path = path.substring(0, path.length() - 3);
            }
            StringTemplateGroup templateGroup = new StringTemplateGroup(path);
            templateGroup.setFileCharEncoding(this.getEncoding().displayName());
            this.template = templateGroup.getInstanceOf(path);
        }

        protected void applyTemplate(ExecutionContext executionContext, Writer writer) {
            StringTemplate thisTransTemplate = this.template.getInstanceOf();
            Map beans = executionContext.getBeanContext().getBeanMap();
            thisTransTemplate.setAttributes(beans);
            String templatingResult = thisTransTemplate.toString();
            try {
                writer.write(templatingResult);
            }
            catch (IOException e) {
                throw new SmooksException(e.getMessage(), (Throwable)e);
            }
        }

        public boolean consumes(Object object) {
            return this.template.getTemplate().contains(object.toString());
        }

        @Override
        protected void applyTemplate(Element element, ExecutionContext executionContext, Writer writer) {
            this.applyTemplate(executionContext, writer);
        }
    }
}

