/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.templating.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.FilterBypass;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.cartridges.templating.AbstractTemplateProcessor;
import org.smooks.engine.delivery.AbstractParser;
import org.smooks.engine.delivery.dom.serialize.GhostElementSerializerVisitor;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.support.ClassUtil;
import org.smooks.support.DomUtils;
import org.smooks.support.StreamUtils;
import org.smooks.support.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@VisitBeforeReport(condition="false")
@VisitAfterReport(summary="Applied XSL Template.", detailTemplate="reporting/XslTemplateProcessor_After.html")
public class XslTemplateProcessor
extends AbstractTemplateProcessor
implements Consumer,
FilterBypass {
    static final ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(XslTemplateProcessor.class);
    private String xslString;
    private Templates xslTemplate;
    private boolean isTemplatelet;
    @Inject
    private Boolean enableFilterBypass = true;
    private volatile Boolean isXMLTargetedConfiguration;
    private final boolean isSynchronized = Boolean.getBoolean("org.smooks.cartridges.templating.xslt.synchronized");
    private final DomErrorHandler logErrorHandler = new DomErrorHandler();

    @Override
    protected void loadTemplate(ResourceConfig resourceConfig) throws IOException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        boolean isInlineXSL = resourceConfig.isInline();
        byte[] xslBytes = resourceConfig.getBytes();
        this.xslString = new String(xslBytes, this.getEncoding().name());
        this.isTemplatelet = this.isTemplatelet(isInlineXSL, new String(xslBytes));
        if (this.isTemplatelet) {
            String templateletWrapper = new String(StreamUtils.readStream((InputStream)ClassUtil.getResourceAsStream((String)"doc-files/templatelet.xsl", this.getClass())));
            String templatelet = new String(xslBytes);
            templateletWrapper = StringUtils.replace((String)templateletWrapper, (String)"@@@templatelet@@@", (String)templatelet);
            xslBytes = templateletWrapper.getBytes();
            this.xslString = new String(xslBytes, this.getEncoding().name());
        }
        boolean failOnWarning = (Boolean)resourceConfig.getParameterValue("failOnWarning", Boolean.class, (Object)true);
        StreamSource xslStreamSource = new StreamSource(new StringReader(this.xslString));
        transformerFactory.setErrorListener(new XslErrorListener(failOnWarning));
        this.xslTemplate = transformerFactory.newTemplates(xslStreamSource);
    }

    private boolean isTemplatelet(boolean inlineXSL, String templateCode) {
        try {
            Document xslDoc = XmlUtil.parseStream((Reader)new StringReader(templateCode), (ErrorHandler)this.logErrorHandler);
            Element rootElement = xslDoc.getDocumentElement();
            String rootElementNS = rootElement.getNamespaceURI();
            return inlineXSL && (rootElementNS == null || !rootElementNS.equals("http://www.w3.org/1999/XSL/Transform") || !DomUtils.getName((Element)rootElement).equals("stylesheet"));
        }
        catch (IOException | ParserConfigurationException e) {
            throw new SmooksConfigException("Unable to parse XSL Document (Stylesheet/Templatelet).", (Throwable)e);
        }
        catch (SAXException e) {
            return inlineXSL;
        }
    }

    public boolean consumes(Object object) {
        return this.xslString.contains(object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyTemplate(Element element, ExecutionContext executionContext, Writer writer) {
        Element ghostElement;
        block8: {
            Document ownerDoc = element.getOwnerDocument();
            ghostElement = GhostElementSerializerVisitor.createElement((Document)ownerDoc);
            try {
                if (this.isSynchronized) {
                    Templates templates = this.xslTemplate;
                    synchronized (templates) {
                        this.performTransform(element, ghostElement, ownerDoc, executionContext);
                        break block8;
                    }
                }
                this.performTransform(element, ghostElement, ownerDoc, executionContext);
            }
            catch (TransformerException e) {
                throw new SmooksException("Error applying XSLT to node [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath((Node)element) + "]", (Throwable)e);
            }
        }
        try {
            writer.write(XmlUtil.serialize((NodeList)ghostElement.getChildNodes(), (boolean)Boolean.parseBoolean((String)ParameterAccessor.getParameterValue((String)"close.empty.elements", String.class, (Object)"false", (ContentDeliveryConfig)executionContext.getContentDeliveryRuntime().getContentDeliveryConfig()))));
        }
        catch (IOException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTransform(Element element, Element transRes, Document ownerDoc, ExecutionContext executionContext) throws TransformerException {
        Transformer transformer = this.xslTemplate.newTransformer();
        try {
            executionContextThreadLocal.set(executionContext);
            if (element == ownerDoc.getDocumentElement()) {
                transformer.transform(new DOMSource(ownerDoc), new DOMResult(transRes));
            } else {
                transformer.transform(new DOMSource(element), new DOMResult(transRes));
            }
        }
        finally {
            executionContextThreadLocal.remove();
        }
    }

    public boolean bypass(ExecutionContext executionContext, Source source, Result result) throws SmooksException {
        if (!this.enableFilterBypass.booleanValue()) {
            return false;
        }
        if (!this.isXMLTargetedConfiguration(executionContext)) {
            return false;
        }
        if ((source instanceof StreamSource || source instanceof DOMSource) && (result instanceof StreamResult || result instanceof DOMResult)) {
            try {
                Transformer transformer = this.xslTemplate.newTransformer();
                transformer.transform(source, result);
                return true;
            }
            catch (TransformerException e) {
                throw new SmooksException("Error applying XSLT.", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isXMLTargetedConfiguration(ExecutionContext executionContext) {
        if (this.isXMLTargetedConfiguration == null) {
            XslTemplateProcessor xslTemplateProcessor = this;
            synchronized (xslTemplateProcessor) {
                if (this.isXMLTargetedConfiguration == null) {
                    ResourceConfig readerConfiguration = AbstractParser.getSAXParserConfiguration((ContentDeliveryConfig)executionContext.getContentDeliveryRuntime().getContentDeliveryConfig());
                    this.isXMLTargetedConfiguration = readerConfiguration != null ? Boolean.valueOf(readerConfiguration.getResource() == null) : Boolean.valueOf(true);
                }
            }
        }
        return this.isXMLTargetedConfiguration;
    }

    private static class DomErrorHandler
    implements ErrorHandler {
        private DomErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOGGER.debug("SaxParseException error was reported : ", (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOGGER.debug("SaxParseException fatal error was reported : ", (Throwable)exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOGGER.debug("SaxParseException warning error was reported : ", (Throwable)exception);
        }
    }

    private static class XslErrorListener
    implements ErrorListener {
        private final boolean failOnWarning;

        public XslErrorListener(boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            if (this.failOnWarning) {
                throw exception;
            }
            LOGGER.debug("XSL Warning.", (Throwable)exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

