/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.memento.Memento;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.cartridges.rules.RuleEvalResult;
import org.smooks.cartridges.rules.RuleProvider;
import org.smooks.cartridges.rules.RuleProviderAccessor;
import org.smooks.cartridges.validation.OnFail;
import org.smooks.cartridges.validation.OnFailResult;
import org.smooks.cartridges.validation.ValidationException;
import org.smooks.cartridges.validation.ValidationResult;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.memento.TextAccumulatorMemento;
import org.smooks.io.payload.FilterResult;
import org.smooks.resource.URIResourceLocator;
import org.smooks.support.DomUtils;
import org.smooks.support.FreeMarkerTemplate;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(condition="false")
@VisitAfterReport(summary="Applied validation rule '${resource.parameters.name}'.")
public final class Validator
implements ChildrenVisitor,
AfterVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Validator.class);
    private String compositRuleName;
    private String ruleProviderName;
    private String ruleName;
    private RuleProvider ruleProvider;
    private OnFail onFail = OnFail.ERROR;
    @Inject
    private ApplicationContext appContext;
    @Inject
    private ResourceConfig resourceConfig;
    private String targetAttribute;
    private String messageBundleBaseName;
    private int maxFails;

    public Validator() {
    }

    @PostConstruct
    public void postConstruct() {
        this.targetAttribute = this.resourceConfig.getSelectorPath().getTargetAttribute();
    }

    public Validator(String compositeRuleName, OnFail onFail) {
        this.setCompositRuleName(compositeRuleName);
        this.onFail = onFail;
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.targetAttribute != null) {
            OnFailResultImpl result = this._validate(element.getAttribute(this.targetAttribute), executionContext);
            if (result != null) {
                result.setFailFragmentPath(DomUtils.getXPath((Node)element) + "/@" + this.targetAttribute);
                this.assertValidationException(result, executionContext);
            }
        } else {
            TextAccumulatorMemento textAccumulatorMemento = new TextAccumulatorMemento((Fragment)new NodeFragment((Node)element), (Visitor)this);
            executionContext.getMementoCaretaker().restore((Memento)textAccumulatorMemento);
            OnFailResultImpl result = this._validate(textAccumulatorMemento.getText(), executionContext);
            if (result != null) {
                result.setFailFragmentPath(DomUtils.getXPath((Node)element));
                this.assertValidationException(result, executionContext);
            }
        }
    }

    private void assertValidationException(OnFailResultImpl result, ExecutionContext executionContext) {
        if (this.onFail == OnFail.FATAL) {
            throw new ValidationException("A FATAL validation failure has occured " + result, result);
        }
        ValidationResult validationResult = this.getValidationResult(executionContext);
        if (validationResult.getNumFailures() > this.maxFails) {
            throw new ValidationException("The maximum number of allowed validation failures (" + this.maxFails + ") has been exceeded.", result);
        }
    }

    void validate(String text, ExecutionContext executionContext) throws ValidationException {
        OnFailResultImpl result = this._validate(text, executionContext);
        if (result != null) {
            this.assertValidationException(result, executionContext);
        }
    }

    private OnFailResultImpl _validate(String text, ExecutionContext executionContext) throws ValidationException {
        if (this.ruleProvider == null) {
            this.setRuleProvider(executionContext);
        }
        RuleEvalResult result = this.ruleProvider.evaluate(this.ruleName, (CharSequence)text, executionContext);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(result.toString());
        }
        if (!result.matched()) {
            ValidationResult validationResult = this.getValidationResult(executionContext);
            OnFailResultImpl onFailResult = new OnFailResultImpl();
            onFailResult.setRuleResult(result);
            onFailResult.setBeanContext(executionContext.getBeanContext().getBeanMap());
            validationResult.addResult(onFailResult, this.onFail);
            return onFailResult;
        }
        return null;
    }

    private ValidationResult getValidationResult(ExecutionContext executionContext) {
        ValidationResult validationResult = (ValidationResult)((Object)FilterResult.getResult((ExecutionContext)executionContext, ValidationResult.class));
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        return validationResult;
    }

    private synchronized void setRuleProvider(ExecutionContext executionContext) {
        if (this.ruleProvider != null) {
            return;
        }
        this.ruleProvider = RuleProviderAccessor.get((ApplicationContext)this.appContext, (String)this.ruleProviderName);
        if (this.ruleProvider == null) {
            throw new SmooksException("Unknown rule provider '" + this.ruleProviderName + "'.");
        }
        this.setMessageBundleBaseName();
        String maxFailsConfig = executionContext.getConfigParameter("validation.maxFails");
        if (maxFailsConfig != null) {
            try {
                this.maxFails = Integer.parseInt(maxFailsConfig.trim());
            }
            catch (NumberFormatException e) {
                throw new SmooksConfigException("Invalid config value '" + maxFailsConfig.trim() + "' for global parameter '" + "validation.maxFails" + "'.  Must be a valid Integer value.");
            }
        } else {
            this.maxFails = Integer.MAX_VALUE;
        }
    }

    private void setMessageBundleBaseName() {
        String ruleSource = this.ruleProvider.getSrc();
        File srcFile = new File(ruleSource);
        String srcFileName = srcFile.getName();
        int indexOfExt = srcFileName.lastIndexOf(46);
        File parentFolder = srcFile.getParentFile();
        this.messageBundleBaseName = indexOfExt != -1 ? srcFileName.substring(0, indexOfExt) : ruleSource;
        this.messageBundleBaseName = parentFolder != null ? parentFolder.getPath() + "/i18n/" + this.messageBundleBaseName : "i18n/" + this.messageBundleBaseName;
        this.messageBundleBaseName = this.messageBundleBaseName.replace('\\', '/');
    }

    public String toString() {
        return String.format("%s [rule=%s, onFail=%s]", new Object[]{this.getClass().getSimpleName(), this.compositRuleName, this.onFail});
    }

    @Inject
    public void setCompositRuleName(@Named(value="name") String compositRuleName) {
        this.compositRuleName = compositRuleName;
        this.ruleProviderName = RuleProviderAccessor.parseRuleProviderName((String)compositRuleName);
        this.ruleName = RuleProviderAccessor.parseRuleName((String)compositRuleName);
    }

    public String getCompositRuleName() {
        return this.compositRuleName;
    }

    @Inject
    public void setOnFail(Optional<OnFail> onFail) {
        this.onFail = onFail.orElse(OnFail.ERROR);
    }

    public OnFail getOnFail() {
        return this.onFail;
    }

    public Validator setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
        return this;
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        if (this.targetAttribute == null) {
            TextAccumulatorMemento textAccumulatorMemento = new TextAccumulatorMemento((Fragment)new NodeFragment(characterData.getParentNode()), (Visitor)this);
            executionContext.getMementoCaretaker().restore((Memento)textAccumulatorMemento);
            textAccumulatorMemento.accumulateText(characterData.getTextContent());
            executionContext.getMementoCaretaker().capture((Memento)textAccumulatorMemento);
        }
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
    }

    private static class ResourceBundleClassLoader
    extends ClassLoader {
        private ResourceBundleClassLoader() {
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            try {
                return new URIResourceLocator().getResource(name);
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private class OnFailResultImpl
    implements OnFailResult {
        private String failFragmentPath;
        private RuleEvalResult ruleResult;
        public Map<String, Object> beanContext;

        private OnFailResultImpl() {
        }

        public void setFailFragmentPath(String failFragmentPath) {
            this.failFragmentPath = failFragmentPath;
        }

        @Override
        public String getFailFragmentPath() {
            return this.failFragmentPath;
        }

        public void setRuleResult(RuleEvalResult ruleResult) {
            this.ruleResult = ruleResult;
        }

        @Override
        public RuleEvalResult getFailRuleResult() {
            return this.ruleResult;
        }

        public void setBeanContext(Map<String, Object> beanContext) {
            this.beanContext = new HashMap<String, Object>();
            this.beanContext.putAll(beanContext);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }

        @Override
        public String getMessage(Locale locale) {
            if (this.ruleResult.getEvalException() != null) {
                return this.ruleResult.getEvalException().getMessage();
            }
            String message = this.getMessage(locale, Validator.this.ruleName);
            if (message == null) {
                return this.toString();
            }
            if (message.startsWith("ftl:")) {
                FreeMarkerTemplate template = new FreeMarkerTemplate(message.substring("ftl:".length()));
                this.beanContext.put("ruleResult", this.ruleResult);
                this.beanContext.put("path", this.failFragmentPath);
                message = template.apply(this.beanContext);
            }
            return message;
        }

        private String getMessage(Locale locale, String messageName) {
            ResourceBundle bundle = this.getMessageBundle(locale);
            if (messageName == null || bundle == null) {
                return null;
            }
            return bundle.getString(messageName);
        }

        private ResourceBundle getMessageBundle(Locale locale) {
            try {
                return ResourceBundle.getBundle(Validator.this.messageBundleBaseName, locale, new ResourceBundleClassLoader());
            }
            catch (MissingResourceException e) {
                LOGGER.warn("Failed to load Validation rule message bundle '" + Validator.this.messageBundleBaseName + "'.  This resource must be on the classpath!", (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return "[" + this.failFragmentPath + "] " + this.ruleResult.toString();
        }
    }
}

