/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.yaml;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.cartridges.yaml.AliasStrategy;
import org.smooks.cartridges.yaml.ElementNameFormatter;
import org.smooks.cartridges.yaml.KeyMapDigester;
import org.smooks.cartridges.yaml.handler.AliasReferencingEventHandler;
import org.smooks.cartridges.yaml.handler.AliasResolvingEventHandler;
import org.smooks.cartridges.yaml.handler.EventHandler;
import org.smooks.cartridges.yaml.handler.YamlEventStreamHandler;
import org.smooks.cartridges.yaml.handler.YamlToSaxHandler;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.yaml.snakeyaml.Yaml;

public class YamlReader
implements SmooksXMLReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlReader.class);
    public static final String CONFIG_PARAM_KEY_MAP = "keyMap";
    public static final String XML_ROOT = "yaml";
    public static final String XML_DOCUMENT = "document";
    public static final String XML_ARRAY_ELEMENT_NAME = "element";
    public static final String DEFAULT_ANCHOR_NAME = "id";
    public static final String DEFAULT_ALIAS_NAME = "ref";
    private ContentHandler contentHandler;
    private ExecutionContext executionContext;
    @Inject
    private String rootName = "yaml";
    @Inject
    private String documentName = "document";
    @Inject
    private String arrayElementName = "element";
    @Inject
    private Optional<String> keyWhitspaceReplacement;
    @Inject
    private Optional<String> keyPrefixOnNumeric;
    @Inject
    private Optional<String> illegalElementNameCharReplacement;
    @Inject
    private String anchorAttributeName = "id";
    @Inject
    private String aliasAttributeName = "ref";
    @Inject
    private Boolean indent = false;
    @Inject
    private AliasStrategy aliasStrategy = AliasStrategy.REFER;
    @Inject
    private ResourceConfig resourceConfig;
    private final Yaml yaml = new Yaml();
    private YamlEventStreamHandler yamlEventStreamParser;

    @PostConstruct
    public void initialize() {
        ElementNameFormatter elementNameFormatter = new ElementNameFormatter(this.initKeyMap(), this.keyWhitspaceReplacement.orElse(null), this.keyPrefixOnNumeric.orElse(null), this.illegalElementNameCharReplacement.orElse(null));
        this.yamlEventStreamParser = new YamlEventStreamHandler(elementNameFormatter, this.documentName, this.arrayElementName);
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource yamlInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse YAML stream.");
        }
        if (this.executionContext == null) {
            throw new IllegalStateException("Smooks container 'executionContext' not set.  Cannot parse YAML stream.");
        }
        try {
            Reader yamlStreamReader = yamlInputSource.getCharacterStream();
            if (yamlStreamReader == null) {
                throw new SmooksException("The InputSource doesn't provide a Reader character stream. Make sure that you supply a reader to the Smooks.filterSource method.");
            }
            YamlToSaxHandler yamlToSaxHandler = new YamlToSaxHandler(this.contentHandler, this.anchorAttributeName, this.aliasAttributeName, this.indent);
            EventHandler eventHandler = this.aliasStrategy == AliasStrategy.REFER ? new AliasReferencingEventHandler(yamlToSaxHandler) : new AliasResolvingEventHandler(this.yamlEventStreamParser, yamlToSaxHandler, this.aliasStrategy == AliasStrategy.REFER_RESOLVE);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Starting YAML parsing");
            }
            Iterable yamlEventStream = this.yaml.parse(yamlStreamReader);
            this.contentHandler.startDocument();
            yamlToSaxHandler.startElementStructure(this.rootName, null, false);
            this.yamlEventStreamParser.handle(eventHandler, yamlEventStream);
            yamlToSaxHandler.endElementStructure(this.rootName);
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
            this.executionContext = null;
        }
    }

    private Map<String, String> initKeyMap() {
        Parameter keyMapParam = this.resourceConfig.getParameter(CONFIG_PARAM_KEY_MAP, Object.class);
        if (keyMapParam != null) {
            Object objValue = keyMapParam.getValue();
            if (objValue instanceof Map) {
                return (HashMap)objValue;
            }
            Element keyMapParamElement = keyMapParam.getXml();
            if (keyMapParamElement != null) {
                return KeyMapDigester.digest(keyMapParamElement);
            }
            throw new SmooksException("Sorry, the key properties must be available as XML DOM. Please configure using XML.");
        }
        return Collections.emptyMap();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getArrayElementName() {
        return this.arrayElementName;
    }

    public void setArrayElementName(String arrayElementName) {
        this.arrayElementName = arrayElementName;
    }

    public String getKeyWhitspaceReplacement() {
        return this.keyWhitspaceReplacement.orElse(null);
    }

    public void setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        this.keyWhitspaceReplacement = Optional.ofNullable(keyWhitspaceReplacement);
    }

    public String getKeyPrefixOnNumeric() {
        return this.keyPrefixOnNumeric.orElse(null);
    }

    public void setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        this.keyPrefixOnNumeric = Optional.ofNullable(keyPrefixOnNumeric);
    }

    public String getIllegalElementNameCharReplacement() {
        return this.illegalElementNameCharReplacement.orElse(null);
    }

    public void setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        this.illegalElementNameCharReplacement = Optional.ofNullable(illegalElementNameCharReplacement);
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

