/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.yaml.handler;

import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.cartridges.yaml.ElementNameFormatter;
import org.smooks.cartridges.yaml.handler.EventHandler;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;

public class YamlEventStreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlEventStreamHandler.class);
    private final ElementNameFormatter nameFormatter;
    private final String arrayElementName;
    private String documentName;

    public YamlEventStreamHandler(ElementNameFormatter nameFormatter, String documentName, String arrayElementName) {
        this.nameFormatter = nameFormatter;
        this.arrayElementName = arrayElementName;
        this.documentName = documentName;
    }

    public void handle(EventHandler eventHandler, Iterable<Event> yamlEventStream) throws SAXException {
        Stack<String> elementNameStack = new Stack<String>();
        Stack<Type> typeStack = new Stack<Type>();
        boolean isNextElementName = true;
        boolean outputStructAsElement = false;
        for (Event e : yamlEventStream) {
            String elementName;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Event: " + e);
            }
            if (e.is(Event.ID.DocumentStart)) {
                elementNameStack.push(this.documentName);
                outputStructAsElement = true;
                continue;
            }
            if (e.is(Event.ID.Scalar)) {
                ScalarEvent es = (ScalarEvent)e;
                if (isNextElementName && !this.lastTypeIsArray(typeStack)) {
                    String name = this.nameFormatter.format(es.getValue());
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Element name: " + name);
                    }
                    elementNameStack.push(name);
                    eventHandler.addNameEvent(es, name);
                    isNextElementName = false;
                    continue;
                }
                elementName = typeStack.peek() == Type.SEQUENCE ? this.arrayElementName : (String)elementNameStack.pop();
                eventHandler.addValueEvent(es, elementName, es.getValue());
                isNextElementName = true;
                continue;
            }
            if (e.is(Event.ID.MappingStart) || e.is(Event.ID.SequenceStart)) {
                CollectionStartEvent cse = (CollectionStartEvent)e;
                if (outputStructAsElement) {
                    elementName = this.lastTypeIsArray(typeStack) ? this.arrayElementName : (String)elementNameStack.peek();
                    eventHandler.startStructureEvent(cse, elementName);
                }
                typeStack.push(e.is(Event.ID.SequenceStart) ? Type.SEQUENCE : Type.MAPPING);
                outputStructAsElement = true;
                isNextElementName = true;
                continue;
            }
            if (e.is(Event.ID.MappingEnd) || e.is(Event.ID.SequenceEnd)) {
                typeStack.pop();
                boolean typeStackPeekIsArray = this.lastTypeIsArray(typeStack);
                if (!elementNameStack.empty() && !typeStackPeekIsArray) {
                    eventHandler.endStructureEvent(e, (String)elementNameStack.pop());
                }
                if (!typeStackPeekIsArray) continue;
                eventHandler.endStructureEvent(e, this.arrayElementName);
                continue;
            }
            if (!e.is(Event.ID.Alias)) continue;
            String elementName2 = this.lastTypeIsArray(typeStack) ? this.arrayElementName : (String)elementNameStack.pop();
            eventHandler.addAliasEvent((AliasEvent)e, elementName2);
            isNextElementName = true;
        }
    }

    private boolean lastTypeIsArray(Stack<Type> typeStack) {
        return !typeStack.empty() && typeStack.peek() == Type.SEQUENCE;
    }

    private static enum Type {
        MAPPING,
        SEQUENCE;

    }
}

