/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.yaml.handler;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class YamlToSaxHandler {
    private static final AttributesImpl EMPTY_ATTRIBS = new AttributesImpl();
    private static final String ATTRIBUTE_IDREF = "IDREF";
    private static final String ATTRIBUTE_ID = "ID";
    private final ContentHandler contentHandler;
    private final String anchorAttributeName;
    private final String aliasAttributeName;
    private final boolean indent;
    private int elementLevel = 0;
    private static char[] INDENT = new String("\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").toCharArray();

    public YamlToSaxHandler(ContentHandler contentHandler, String anchorAttributeName, String aliasAttributeName, boolean indent) {
        this.contentHandler = contentHandler;
        this.anchorAttributeName = anchorAttributeName;
        this.aliasAttributeName = aliasAttributeName;
        this.indent = indent;
    }

    public void startElementStructure(String name, String anchorName, boolean addAnchorAttribute) throws SAXException {
        this.indent();
        this.startElement(name, anchorName, addAnchorAttribute);
        ++this.elementLevel;
    }

    public void endElementStructure(String name) throws SAXException {
        --this.elementLevel;
        this.indent();
        this.endElement(name);
    }

    public void addContentElement(String name, String value, String anchorName, boolean addAnchorAttribute) throws SAXException {
        this.indent();
        this.startElement(name, anchorName, addAnchorAttribute);
        if (value != null && value.length() > 0) {
            this.contentHandler.characters(value.toCharArray(), 0, value.length());
        }
        this.endElement(name);
    }

    private void startElement(String name, String anchorName, boolean addAnchorAttribute) throws SAXException {
        AttributesImpl attributes;
        if (anchorName == null) {
            attributes = EMPTY_ATTRIBS;
        } else {
            String attributeType;
            attributes = new AttributesImpl();
            String attributeName = addAnchorAttribute ? this.anchorAttributeName : this.aliasAttributeName;
            String string = attributeType = addAnchorAttribute ? ATTRIBUTE_ID : ATTRIBUTE_IDREF;
            if (addAnchorAttribute) {
                // empty if block
            }
            attributes.addAttribute("", attributeName, attributeName, attributeType, anchorName);
        }
        this.contentHandler.startElement("", name, "", attributes);
    }

    private void endElement(String name) throws SAXException {
        this.contentHandler.endElement("", name, "");
    }

    private void indent() throws SAXException {
        if (this.indent) {
            this.contentHandler.characters(INDENT, 0, this.elementLevel + 1);
        }
    }
}

