/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.yaml;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElementNameFormatter {
    private static final Pattern ILLEGAL_ELEMENT_NAME_PATTERN = Pattern.compile("^[.]|[^a-zA-Z0-9_.-]");
    private final Map<String, String> keyMap;
    private final String keyWhitspaceReplacement;
    private final String keyPrefixOnNumeric;
    private final String illegalElementNameCharReplacement;
    private final boolean doKeyReplacement;
    private final boolean doKeyWhitspaceReplacement;
    private final boolean doPrefixOnNumericKey;
    private final boolean doIllegalElementNameCharReplacement;

    public ElementNameFormatter(Map<String, String> keyMap, String keyWhitspaceReplacement, String keyPrefixOnNumeric, String illegalElementNameCharReplacement) {
        this.keyMap = keyMap;
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
        this.doKeyReplacement = !keyMap.isEmpty();
        this.doKeyWhitspaceReplacement = keyWhitspaceReplacement != null;
        this.doPrefixOnNumericKey = keyPrefixOnNumeric != null;
        this.doIllegalElementNameCharReplacement = illegalElementNameCharReplacement != null;
    }

    public String format(String text) {
        boolean replacedKey = false;
        if (this.doKeyReplacement) {
            String mappedKey = this.keyMap.get(text);
            boolean bl = replacedKey = mappedKey != null;
            if (replacedKey) {
                text = mappedKey;
            }
        }
        if (!replacedKey) {
            if (this.doKeyWhitspaceReplacement) {
                text = text.replace(" ", this.keyWhitspaceReplacement);
            }
            if (this.doPrefixOnNumericKey && Character.isDigit(text.charAt(0))) {
                text = this.keyPrefixOnNumeric + text;
            }
            if (this.doIllegalElementNameCharReplacement) {
                Matcher matcher = ILLEGAL_ELEMENT_NAME_PATTERN.matcher(text);
                text = matcher.replaceAll(this.illegalElementNameCharReplacement);
            }
        }
        return text;
    }
}

