/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.smooks.assertion.AssertArgument;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static byte[] readStream(InputStream stream) throws IOException {
        int readCount;
        AssertArgument.isNotNull(stream, "stream");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] byteBuf = new byte[1024];
        while ((readCount = stream.read(byteBuf)) != -1) {
            bytesOut.write(byteBuf, 0, readCount);
        }
        return bytesOut.toByteArray();
    }

    public static String readStreamAsString(InputStream stream, String encoding) throws IOException {
        AssertArgument.isNotNull(stream, "stream");
        AssertArgument.isNotNull(encoding, "encoding");
        return new String(StreamUtils.readStream(stream), encoding);
    }

    public static String readStream(Reader stream) throws IOException {
        AssertArgument.isNotNull(stream, "stream");
        StringBuffer streamString = new StringBuffer();
        char[] readBuffer = new char[256];
        int readCount = 0;
        while ((readCount = stream.read(readBuffer)) != -1) {
            streamString.append(readBuffer, 0, readCount);
        }
        return streamString.toString();
    }

    public static boolean compareCharStreams(InputStream s1, InputStream s2) {
        try {
            StringBuffer s1Buf = StreamUtils.trimLines(s1);
            StringBuffer s2Buf = StreamUtils.trimLines(s2);
            return s1Buf.toString().equals(s2Buf.toString());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean compareCharStreams(Reader s1, Reader s2) {
        try {
            StringBuffer s1Buf = StreamUtils.trimLines(s1);
            StringBuffer s2Buf = StreamUtils.trimLines(s2);
            return s1Buf.toString().equals(s2Buf.toString());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean compareCharStreams(String s1, String s2) {
        return StreamUtils.compareCharStreams(new StringReader(s1), new StringReader(s2));
    }

    public static StringBuffer trimLines(Reader charStream) throws IOException {
        String line;
        StringBuffer stringBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(charStream);
        while ((line = reader.readLine()) != null) {
            stringBuf.append(line.trim());
        }
        return stringBuf;
    }

    public static String normalizeLines(String string, boolean trim) throws IOException {
        return StreamUtils.normalizeLines(new StringReader(string), trim);
    }

    public static String normalizeLines(Reader charStream, boolean trim) throws IOException {
        String line;
        StringBuffer stringBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(charStream);
        while ((line = reader.readLine()) != null) {
            if (trim) {
                stringBuf.append(line.trim());
            } else {
                stringBuf.append(line);
            }
            stringBuf.append('\n');
        }
        return stringBuf.toString();
    }

    public static StringBuffer trimLines(InputStream charStream) throws IOException {
        return StreamUtils.trimLines(new InputStreamReader(charStream, StandardCharsets.UTF_8));
    }

    public static String trimLines(String charStream) throws IOException {
        return StreamUtils.trimLines(new StringReader(charStream)).toString();
    }
}

