/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Hashtable;
import org.smooks.support.ClassUtil;
import org.smooks.support.StreamUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class LocalEntityResolver
implements EntityResolver {
    private String entityCPLocation;
    private File localEntityFolder;
    private static final Hashtable<String, byte[]> entities = new Hashtable();
    private String docType;

    public LocalEntityResolver(String entityCPLocation) {
        this.entityCPLocation = entityCPLocation;
    }

    public LocalEntityResolver(File localEntityFolder) {
        if (localEntityFolder == null) {
            throw new IllegalStateException("Cannot resolve local entity.  Local entity folder arg 'null'.");
        }
        if (!localEntityFolder.exists()) {
            throw new IllegalStateException("Cannot resolve local entity.  Local entity folder not present: [" + localEntityFolder.getAbsolutePath() + "].");
        }
        this.localEntityFolder = localEntityFolder;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        byte[] cachedBytes = entities.get(systemId);
        InputSource entityInputSource = null;
        if (cachedBytes == null) {
            URL systemIdUrl = new URL(systemId);
            String entityPath = systemIdUrl.getHost() + systemIdUrl.getFile();
            String entityName = new File(entityPath).getName();
            File fileSysEntity = null;
            InputStream entityStream = null;
            if (this.localEntityFolder != null && !(fileSysEntity = new File(this.localEntityFolder, entityPath)).exists()) {
                fileSysEntity = new File(this.localEntityFolder, entityName);
            }
            if (this.localEntityFolder != null && fileSysEntity.exists()) {
                entityStream = Files.newInputStream(Paths.get(fileSysEntity.toURI()), new OpenOption[0]);
            } else if (this.entityCPLocation != null) {
                entityStream = ClassUtil.getResourceAsStream(this.entityCPLocation + entityName, this.getClass());
                if (entityStream == null) {
                    return null;
                }
            } else {
                throw new SAXException("Unable to resolve entity. " + this.getClass().getName() + " is not configured with a valid entity file or classpath location.");
            }
            cachedBytes = StreamUtils.readStream(entityStream);
            entities.put(systemId, cachedBytes);
        }
        entityInputSource = new InputSource(new ByteArrayInputStream(cachedBytes));
        entityInputSource.setPublicId(publicId);
        entityInputSource.setSystemId(systemId);
        return entityInputSource;
    }

    public static void clearEntityCache() {
        entities.clear();
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }
}

