/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.smooks.assertion.AssertArgument;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static byte[] readStream(InputStream stream) throws IOException {
        int readCount;
        AssertArgument.isNotNull(stream, "stream");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] byteBuf = new byte[1024];
        while ((readCount = stream.read(byteBuf)) != -1) {
            bytesOut.write(byteBuf, 0, readCount);
        }
        return bytesOut.toByteArray();
    }

    public static String readStreamAsString(InputStream stream, String encoding) throws IOException {
        AssertArgument.isNotNull(stream, "stream");
        AssertArgument.isNotNull(encoding, "encoding");
        return new String(StreamUtils.readStream(stream), encoding);
    }

    public static String readStream(Reader stream) throws IOException {
        int readCount;
        AssertArgument.isNotNull(stream, "stream");
        StringBuffer streamString = new StringBuffer();
        char[] readBuffer = new char[256];
        while ((readCount = stream.read(readBuffer)) != -1) {
            streamString.append(readBuffer, 0, readCount);
        }
        return streamString.toString();
    }
}

