/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.IOException;
import java.util.List;
import org.smurn.jply.BinaryPlyInputStream;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.ListProperty;
import org.smurn.jply.Property;

class BinaryElementReader
implements ElementReader {
    private final ElementType type;
    private final BinaryPlyInputStream stream;
    private final int count;
    private int nextRow = 0;
    private boolean closed = false;

    BinaryElementReader(ElementType type, int count, BinaryPlyInputStream stream) {
        if (type == null || stream == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.count = count;
        this.stream = stream;
    }

    public ElementType getElementType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public Element readElement() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        if (this.nextRow >= this.getCount()) {
            return null;
        }
        List<Property> properties = this.type.getProperties();
        double[][] values = new double[properties.size()][];
        for (int i = 0; i < values.length; ++i) {
            Property property = properties.get(i);
            values[i] = property instanceof ListProperty ? this.readListProperty((ListProperty)property) : new double[]{this.readProperty(property)};
        }
        ++this.nextRow;
        return new Element(values, this.type);
    }

    private double readProperty(Property property) throws IOException {
        return this.stream.read(property.getType());
    }

    private double[] readListProperty(ListProperty property) throws IOException {
        int valueCount = (int)this.stream.read(property.getCountType());
        double[] values = new double[valueCount];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.stream.read(property.getType());
        }
        return values;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

