/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.smurn.jply.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementType {
    private final String name;
    private final List<Property> properties;
    private final Map<String, Integer> propertyMap;

    public ElementType(String name, List<Property> properties) {
        if (name == null) {
            throw new NullPointerException("name must not be null.");
        }
        if (properties == null) {
            throw new NullPointerException("properties must not be null.");
        }
        this.name = name;
        this.properties = Collections.unmodifiableList(new ArrayList<Property>(properties));
        HashMap<String, Integer> propertyMapTmp = new HashMap<String, Integer>();
        for (int i = 0; i < properties.size(); ++i) {
            propertyMapTmp.put(properties.get(i).getName(), i);
        }
        this.propertyMap = Collections.unmodifiableMap(propertyMapTmp);
        if (this.propertyMap.size() != properties.size()) {
            throw new IllegalArgumentException("properties must have unique names.");
        }
    }

    public ElementType(String name, Property ... properties) {
        this(name, Arrays.asList(properties));
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    Map<String, Integer> getPropertyMap() {
        return this.propertyMap;
    }

    static HeaderEntry parse(String elementLine) throws IOException {
        int count;
        if (!elementLine.startsWith("element ")) {
            throw new IOException("not an element: '" + elementLine + "'");
        }
        String definition = elementLine.substring("element ".length());
        String[] parts = definition.split(" +", 2);
        if (parts.length != 2) {
            throw new IOException("Expected two parts in element definition: '" + elementLine + "'");
        }
        String name = parts[0];
        String countStr = parts[1];
        try {
            count = Integer.parseInt(countStr);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid element entry. Not an integer: '" + countStr + "'.");
        }
        return new HeaderEntry(name, count);
    }

    public String toString() {
        return "element " + this.name + " properties=" + this.properties;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ElementType rhs = (ElementType)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.name, (Object)rhs.name);
        builder.append(this.properties, rhs.properties);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append(this.properties);
        return builder.toHashCode();
    }

    static class HeaderEntry {
        private final String name;
        private final int count;

        public HeaderEntry(String name, int count) {
            this.name = name;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }
    }
}

