/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.IOException;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Format {
    ASCII,
    BINARY_LITTLE_ENDIAN,
    BINARY_BIG_ENDIAN;


    static Format parse(String formatLine) throws IOException {
        if (!formatLine.startsWith("format ")) {
            throw new IOException("not a format definition: '" + formatLine + "'");
        }
        String definition = formatLine.substring("format ".length());
        String[] parts = definition.split(" +", 2);
        if (parts.length != 2) {
            throw new IOException("Format definition must have two values.");
        }
        String format = parts[0];
        String version = parts[1];
        if (!version.equals("1.0")) {
            throw new IOException("Unsupported version of PLY: '" + version + "'. Supported version is 1.0");
        }
        if (format.equals("ascii")) {
            return ASCII;
        }
        if (format.equals("binary_little_endian")) {
            return BINARY_LITTLE_ENDIAN;
        }
        if (format.equals("binary_big_endian")) {
            return BINARY_BIG_ENDIAN;
        }
        throw new IOException("Unsupported format:" + format + ".");
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.US);
    }
}

