/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.smurn.jply.DataType;
import org.smurn.jply.Property;

public class ListProperty
extends Property {
    private final DataType countType;

    public ListProperty(DataType countType, String name, DataType type) {
        super(name, type);
        if (countType == null) {
            throw new NullPointerException("countType must not be null.");
        }
        this.countType = countType;
    }

    public DataType getCountType() {
        return this.countType;
    }

    static Property parse(String line) throws IOException {
        DataType countDataType;
        DataType dataType;
        if (!line.startsWith("property ")) {
            throw new IOException("not a property: '" + line + "'");
        }
        String definition = line.substring("property ".length());
        if (!(definition = definition.trim()).startsWith("list ")) {
            throw new IllegalArgumentException("not a list property: '" + line + "'");
        }
        definition = definition.substring("list ".length());
        String[] parts = (definition = definition.trim()).split(" +", 3);
        if (parts.length != 3) {
            throw new IOException("Expected three parts in list property definition: '" + line + "'");
        }
        String countType = parts[0];
        String type = parts[1];
        String name = parts[2];
        try {
            dataType = DataType.parse(type);
            countDataType = DataType.parse(countType);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        return new ListProperty(countDataType, name, dataType);
    }

    public String toString() {
        return "property list " + (Object)((Object)this.countType) + " " + (Object)((Object)this.getType()) + " " + this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ListProperty rhs = (ListProperty)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.appendSuper(super.equals(obj));
        builder.append((Object)this.countType, (Object)rhs.countType);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.countType);
        return builder.toHashCode();
    }
}

