/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.smurn.jply.AsciiElementReader;
import org.smurn.jply.BinaryElementReader;
import org.smurn.jply.BinaryPlyInputStream;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.Format;
import org.smurn.jply.PlyReader;
import org.smurn.jply.Property;
import org.smurn.jply.UnbufferedASCIIReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlyReaderFile
implements PlyReader {
    private List<ElementType> elements;
    private Map<String, Integer> elementCounts;
    private Format format;
    private BinaryPlyInputStream binaryStream;
    private final PushbackInputStream inputStream;
    private BufferedReader asciiReader;
    private int nextElement = 0;
    private ElementReader currentReader;

    public PlyReaderFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file must not be null.");
        }
        this.inputStream = file.getName().endsWith(".gz") ? new PushbackInputStream(new GZIPInputStream(new FileInputStream(file))) : new PushbackInputStream(new FileInputStream(file));
        this.readHeader(this.inputStream);
    }

    public PlyReaderFile(String file) throws IOException {
        this(new File(file));
    }

    public PlyReaderFile(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream must not be null.");
        }
        this.inputStream = new PushbackInputStream(stream);
        this.readHeader(this.inputStream);
    }

    private void readHeader(PushbackInputStream stream) throws IOException {
        UnbufferedASCIIReader hdrReader = new UnbufferedASCIIReader(stream);
        String magic = hdrReader.readLine();
        if (!"ply".equals(magic)) {
            throw new IOException("Invalid PLY file: does not start with 'ply'.");
        }
        this.format = null;
        ElementType.HeaderEntry currentElement = null;
        ArrayList<Property> currentElementProperties = null;
        this.elements = new ArrayList<ElementType>();
        this.elementCounts = new HashMap<String, Integer>();
        String line = hdrReader.readLine();
        while (true) {
            if (line == null) {
                throw new IOException("Unexpected end of file while reading the header.");
            }
            if (!(line = line.trim()).isEmpty()) {
                if (line.startsWith("format ")) {
                    if (this.format != null) {
                        throw new IOException("Multiple format definitions.");
                    }
                    this.format = Format.parse(line);
                } else if (line.startsWith("element ")) {
                    if (currentElement != null) {
                        ElementType element = new ElementType(currentElement.getName(), currentElementProperties);
                        this.elements.add(element);
                        this.elementCounts.put(currentElement.getName(), currentElement.getCount());
                        currentElement = null;
                        currentElementProperties = null;
                    }
                    currentElement = ElementType.parse(line);
                    currentElementProperties = new ArrayList<Property>();
                } else if (line.startsWith("property ")) {
                    if (currentElement == null) {
                        throw new IOException("Property without element found.");
                    }
                    Property property = Property.parse(line);
                    currentElementProperties.add(property);
                } else {
                    if (line.startsWith("end_header")) break;
                    if (!line.startsWith("comment ")) {
                        throw new IOException("Unsupported header entry: " + line);
                    }
                }
            }
            line = hdrReader.readLine();
        }
        if (currentElement != null) {
            ElementType element = new ElementType(currentElement.getName(), currentElementProperties);
            this.elements.add(element);
            this.elementCounts.put(currentElement.getName(), currentElement.getCount());
            currentElement = null;
            currentElementProperties = null;
        }
        this.elements = Collections.unmodifiableList(this.elements);
        if (this.format == null) {
            throw new IOException("Missing format header entry.");
        }
        switch (this.format) {
            case ASCII: {
                this.asciiReader = new BufferedReader(new InputStreamReader((InputStream)stream, Charset.forName("US-ASCII")));
                this.binaryStream = null;
                break;
            }
            case BINARY_BIG_ENDIAN: {
                this.asciiReader = null;
                this.binaryStream = new BinaryPlyInputStream(Channels.newChannel(stream), ByteOrder.BIG_ENDIAN);
                break;
            }
            case BINARY_LITTLE_ENDIAN: {
                this.asciiReader = null;
                this.binaryStream = new BinaryPlyInputStream(Channels.newChannel(stream), ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                throw new IOException("Unsupported format: " + (Object)((Object)this.format));
            }
        }
    }

    @Override
    public List<ElementType> getElementTypes() {
        return this.elements;
    }

    @Override
    public int getElementCount(String elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType must not be null.");
        }
        Integer count = this.elementCounts.get(elementType);
        if (count == null) {
            throw new IllegalArgumentException("Type does not exist in this file.");
        }
        return count;
    }

    @Override
    public ElementReader nextElementReader() throws IOException {
        if (this.currentReader != null && !this.currentReader.isClosed()) {
            throw new IllegalStateException("Previous element stream needs to be closed first.");
        }
        this.currentReader = this.nextElementReaderInternal();
        return this.currentReader;
    }

    @Override
    public void close() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
        this.inputStream.close();
    }

    private ElementReader nextElementReaderInternal() {
        if (this.nextElement >= this.elements.size()) {
            return null;
        }
        try {
            ElementType type = this.elements.get(this.nextElement);
            switch (this.format) {
                case ASCII: {
                    AsciiElementReader asciiElementReader = new AsciiElementReader(type, this.getElementCount(type.getName()), this.asciiReader);
                    return asciiElementReader;
                }
                case BINARY_BIG_ENDIAN: 
                case BINARY_LITTLE_ENDIAN: {
                    BinaryElementReader binaryElementReader = new BinaryElementReader(type, this.getElementCount(type.getName()), this.binaryStream);
                    return binaryElementReader;
                }
            }
            throw new UnsupportedOperationException("PLY format " + (Object)((Object)this.format) + " is currently not supported.");
        }
        finally {
            ++this.nextElement;
        }
    }
}

