/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.Reader;

class UnbufferedASCIIReader
extends Reader {
    private final PushbackInputStream stream;

    public UnbufferedASCIIReader(PushbackInputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        this.stream = stream;
    }

    public String readLine() throws IOException {
        int c;
        StringBuilder str = new StringBuilder();
        while ((c = this.read()) >= 0) {
            if (c == 10) {
                int peek = this.stream.read();
                if (peek == 13 || peek < 0) break;
                this.stream.unread(peek);
                break;
            }
            if (c == 13) {
                int peek = this.stream.read();
                if (peek == 10 || peek < 0) break;
                this.stream.unread(peek);
                break;
            }
            str.append((char)c);
        }
        return str.toString();
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        byte[] bbuf = new byte[len];
        int bytesRead = this.stream.read(bbuf);
        for (int i = 0; i < bytesRead; ++i) {
            cbuf[off + i] = (char)bbuf[i];
        }
        return bytesRead;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

