/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.util.RandomElementReader;

class BufferedElementReader
implements RandomElementReader {
    private final ElementReader reader;
    private List<Element> buffer = new ArrayList<Element>();
    private int nextElement = 0;
    private boolean closed = false;
    private boolean sourceClosed = false;

    BufferedElementReader(ElementReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        this.reader = reader;
    }

    public ElementType getElementType() {
        return this.reader.getElementType();
    }

    public int getCount() {
        if (this.sourceClosed) {
            return this.buffer.size();
        }
        return this.reader.getCount();
    }

    public Element readElement(int index) throws IOException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is negative.");
        }
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        while (index >= this.buffer.size()) {
            Element element = this.reader.readElement();
            if (element == null) {
                throw new IndexOutOfBoundsException("Index is larger or equal to the number of elements.");
            }
            this.buffer.add(element);
        }
        return this.buffer.get(index);
    }

    public Element readElement() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        while (this.nextElement >= this.buffer.size()) {
            Element element = this.sourceClosed ? null : this.reader.readElement();
            if (element == null) {
                return null;
            }
            this.buffer.add(element);
        }
        return this.buffer.get(this.nextElement++);
    }

    public void reset() {
        this.nextElement = 0;
    }

    public RandomElementReader duplicate() {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        return new RandomElementReader(){
            private boolean closed = false;
            private int nextElement = 0;

            public Element readElement(int index) throws IOException {
                if (this.closed) {
                    throw new IllegalStateException("Reader closed");
                }
                return BufferedElementReader.this.readElement(index);
            }

            public ElementType getElementType() {
                return BufferedElementReader.this.getElementType();
            }

            public int getCount() {
                return BufferedElementReader.this.getCount();
            }

            public Element readElement() throws IOException {
                if (this.nextElement >= this.getCount()) {
                    return null;
                }
                if (this.closed) {
                    throw new IllegalStateException("Reader closed");
                }
                return BufferedElementReader.this.readElement(this.nextElement++);
            }

            public void close() throws IOException {
                this.closed = true;
            }

            public RandomElementReader duplicate() {
                return BufferedElementReader.this.duplicate();
            }

            public boolean isClosed() {
                return this.closed;
            }
        };
    }

    public void detach() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        Element element = this.reader.readElement();
        while (element != null) {
            this.buffer.add(element);
            element = this.reader.readElement();
        }
        this.reader.close();
        this.sourceClosed = true;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceClosed = true;
        this.buffer = null;
        this.reader.close();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

