/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ListProperty;
import org.smurn.jply.Property;
import org.smurn.jply.util.RandomElementReader;

class NormalGenerator {
    private static final double EPSILON = 1.0E-6;
    private boolean counterClockwise = true;

    NormalGenerator() {
    }

    public boolean isCounterClockwise() {
        return this.counterClockwise;
    }

    public void setCounterClockwise(boolean counterClockwise) {
        this.counterClockwise = counterClockwise;
    }

    public void generateNormals(RandomElementReader vertexReader, ElementReader faceReader) throws IOException {
        if (vertexReader == null) {
            throw new NullPointerException("vertexReader must not be null.");
        }
        if (faceReader == null) {
            throw new NullPointerException("faceReader must not be null.");
        }
        if (!vertexReader.getElementType().getName().equals("vertex")) {
            throw new IllegalArgumentException("vertexReader does not read vertices.");
        }
        boolean foundX = false;
        boolean foundY = false;
        boolean foundZ = false;
        for (Property p : vertexReader.getElementType().getProperties()) {
            foundX |= p.getName().equals("x") && !(p instanceof ListProperty);
            foundY |= p.getName().equals("y") && !(p instanceof ListProperty);
            foundZ |= p.getName().equals("z") && !(p instanceof ListProperty);
        }
        if (!(foundX && foundY && foundZ)) {
            throw new IllegalArgumentException("Vertex type does not include the three non-list properties x y and z.");
        }
        if (!faceReader.getElementType().getName().equals("face")) {
            throw new IllegalArgumentException("faceReader does not read faces.");
        }
        boolean foundVertexIndex = false;
        for (Property p : faceReader.getElementType().getProperties()) {
            foundVertexIndex |= p.getName().equals("vertex_index") && p instanceof ListProperty;
        }
        if (!foundVertexIndex) {
            throw new IllegalArgumentException("Face type does not include a list property named vertex_index.");
        }
        Element face = faceReader.readElement();
        while (face != null) {
            this.accumulateNormals(vertexReader, face);
            face = faceReader.readElement();
        }
        Element vertex = vertexReader.readElement();
        while (vertex != null) {
            this.normalize(vertex);
            vertex = vertexReader.readElement();
        }
    }

    private void normalize(Element vertex) {
        double nz;
        double ny;
        double nx = vertex.getDouble("nx");
        double n = Math.sqrt(nx * nx + (ny = vertex.getDouble("ny")) * ny + (nz = vertex.getDouble("nz")) * nz);
        if (n < 1.0E-6) {
            vertex.setDouble("nx", 0.0);
            vertex.setDouble("ny", 0.0);
            vertex.setDouble("nz", 0.0);
        }
        vertex.setDouble("nx", nx / n);
        vertex.setDouble("ny", ny / n);
        vertex.setDouble("nz", nz / n);
    }

    private void accumulateNormals(RandomElementReader vertices, Element face) throws IOException {
        int[] indices = face.getIntList("vertex_index");
        for (int i = 0; i < indices.length; ++i) {
            int post;
            int pre;
            if (this.counterClockwise) {
                pre = (i + indices.length - 1) % indices.length;
                post = (i + 1) % indices.length;
            } else {
                pre = (i + 1) % indices.length;
                post = (i + indices.length - 1) % indices.length;
            }
            try {
                Element centerVertex = vertices.readElement(indices[i]);
                Element preVertex = vertices.readElement(indices[pre]);
                Element postVertex = vertices.readElement(indices[post]);
                this.accumulateNormal(centerVertex, preVertex, postVertex);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }

    private void accumulateNormal(Element center, Element pre, Element post) {
        double bz;
        double by;
        double az;
        double ay;
        double cx = center.getDouble("x");
        double cy = center.getDouble("y");
        double cz = center.getDouble("z");
        double ax = post.getDouble("x") - cx;
        double a = Math.sqrt(ax * ax + (ay = post.getDouble("y") - cy) * ay + (az = post.getDouble("z") - cz) * az);
        if (a < 1.0E-6) {
            return;
        }
        double bx = pre.getDouble("x") - cx;
        double b = Math.sqrt(bx * bx + (by = pre.getDouble("y") - cy) * by + (bz = pre.getDouble("z") - cz) * bz);
        if (b < 1.0E-6) {
            return;
        }
        double nx = ay * bz - az * by;
        double ny = az * bx - ax * bz;
        double nz = ax * by - ay * bx;
        double n = Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (n < 1.0E-6) {
            return;
        }
        double sin = n / (a * b);
        double dot = ax * bx + ay * by + az * bz;
        double angle = dot < 0.0 ? Math.PI - Math.asin(sin) : Math.asin(sin);
        double factor = angle / n;
        center.setDouble("nx", center.getDouble("nx") + (nx *= factor));
        center.setDouble("ny", center.getDouble("ny") + (ny *= factor));
        center.setDouble("nz", center.getDouble("nz") + (nz *= factor));
    }
}

