/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.smurn.jply.DataType;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.ListProperty;
import org.smurn.jply.PlyReader;
import org.smurn.jply.Property;
import org.smurn.jply.util.Axis;
import org.smurn.jply.util.AxisShufflingVertexReader;
import org.smurn.jply.util.NormalGenerator;
import org.smurn.jply.util.NormalMode;
import org.smurn.jply.util.PlanarTexGenStrategy;
import org.smurn.jply.util.RandomElementReader;
import org.smurn.jply.util.RandomPlyReader;
import org.smurn.jply.util.RectBounds;
import org.smurn.jply.util.TesselationMode;
import org.smurn.jply.util.TexGenStrategy;
import org.smurn.jply.util.TextureMode;
import org.smurn.jply.util.TriangulatingFaceReader;
import org.smurn.jply.util.TypeChangingElementReader;
import org.smurn.jply.util.WrappingPlyReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizingPlyReader
implements PlyReader {
    private final RandomPlyReader plyReader;
    private final NormalMode normalMode;
    private final TexGenStrategy texGenStrategy;
    private final boolean generateNormals;
    private final List<ElementType> elementTypes;

    public NormalizingPlyReader(PlyReader plyReader, TesselationMode tesselationMode, NormalMode normalMode, TextureMode textureMode) {
        this(plyReader, tesselationMode, normalMode, textureMode, Axis.X, Axis.Y, Axis.Z);
    }

    public NormalizingPlyReader(PlyReader plyReader, final TesselationMode tesselationMode, NormalMode normalMode, TextureMode textureMode, final Axis x, final Axis y, final Axis z) {
        boolean shuffleAxes;
        ElementType maybeWithNormalTexture;
        ElementType maybeWithNormal;
        ElementType renamedFaceType;
        PlanarTexGenStrategy texGenStrategyTmp;
        if (plyReader == null) {
            throw new NullPointerException("plyReader must not be null.");
        }
        if (tesselationMode == null) {
            throw new NullPointerException("tesslationMode must not be null.");
        }
        if (normalMode == null) {
            throw new NullPointerException("normalMode must not be null.");
        }
        if (textureMode == null) {
            throw new NullPointerException("textureMode must not be null.");
        }
        if (x == null) {
            throw new NullPointerException("x must not be null.");
        }
        if (y == null) {
            throw new NullPointerException("y must not be null.");
        }
        if (z == null) {
            throw new NullPointerException("z must not be null.");
        }
        switch (textureMode) {
            case PASS_THROUGH: {
                texGenStrategyTmp = null;
                break;
            }
            case XY: {
                texGenStrategyTmp = new PlanarTexGenStrategy(Axis.X, Axis.Y);
                break;
            }
            case XZ: {
                texGenStrategyTmp = new PlanarTexGenStrategy(Axis.X, Axis.Z);
                break;
            }
            case YZ: {
                texGenStrategyTmp = new PlanarTexGenStrategy(Axis.Y, Axis.Z);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported texture generation mode.");
            }
        }
        HashMap<String, ElementType> typeMap = new HashMap<String, ElementType>();
        for (ElementType type : plyReader.getElementTypes()) {
            typeMap.put(type.getName(), type);
        }
        if (!typeMap.containsKey("vertex")) {
            throw new IllegalArgumentException("PLY file contains no vertex data.");
        }
        if (!(typeMap.containsKey("face") || tesselationMode == TesselationMode.PASS_THROUGH && normalMode == NormalMode.PASS_THROUGH)) {
            throw new IllegalArgumentException("PLY file contains no face data.");
        }
        final HashMap<String, String> sourceNameMap = new HashMap<String, String>();
        if (typeMap.containsKey("face")) {
            List<Property> properties = ((ElementType)typeMap.get("face")).getProperties();
            ArrayList<Property> newProperties = new ArrayList<Property>();
            boolean renameVertexIndex = false;
            for (Property property : properties) {
                if (property.getName().equals("vertex_indices")) {
                    renameVertexIndex = true;
                    newProperties.add(new ListProperty(((ListProperty)property).getCountType(), "vertex_index", property.getType()));
                    sourceNameMap.put("vertex_index", "vertex_indices");
                    continue;
                }
                newProperties.add(property);
            }
            if (renameVertexIndex) {
                renamedFaceType = new ElementType("face", newProperties);
                typeMap.put("face", renamedFaceType);
            } else {
                renamedFaceType = null;
            }
        } else {
            renamedFaceType = null;
        }
        LinkedList<WrappingPlyReader.WrapperFactory> wrappers = new LinkedList<WrappingPlyReader.WrapperFactory>();
        if (tesselationMode == TesselationMode.TRIANGLES || renamedFaceType != null) {
            ElementType newFaceType = renamedFaceType != null ? renamedFaceType : (ElementType)typeMap.get("face");
            wrappers.add(new WrappingPlyReader.WrapperFactory((ElementType)typeMap.get("face"), newFaceType){

                public ElementReader wrap(ElementReader reader) {
                    ElementReader wrapped = reader;
                    if (renamedFaceType != null) {
                        wrapped = new TypeChangingElementReader(wrapped, renamedFaceType, sourceNameMap);
                    }
                    if (tesselationMode == TesselationMode.TRIANGLES) {
                        wrapped = new TriangulatingFaceReader(wrapped);
                    }
                    return wrapped;
                }
            });
        }
        final ElementType unwrappedVertexType = (ElementType)typeMap.get("vertex");
        if (normalMode != NormalMode.PASS_THROUGH) {
            maybeWithNormal = NormalizingPlyReader.addNormalProps(unwrappedVertexType);
            this.generateNormals = !maybeWithNormal.equals(unwrappedVertexType);
        } else {
            maybeWithNormal = unwrappedVertexType;
            this.generateNormals = false;
        }
        if (texGenStrategyTmp != null) {
            maybeWithNormalTexture = NormalizingPlyReader.addTextureProps(maybeWithNormal);
            if (maybeWithNormalTexture.equals(maybeWithNormal)) {
                texGenStrategyTmp = null;
            }
        } else {
            maybeWithNormalTexture = maybeWithNormal;
        }
        final ElementType wrappedVertexType = maybeWithNormalTexture;
        boolean bl = shuffleAxes = x != Axis.X || y != Axis.Y || z != Axis.Z;
        if (!unwrappedVertexType.equals(wrappedVertexType) || shuffleAxes) {
            typeMap.put("vertex", wrappedVertexType);
            wrappers.add(new WrappingPlyReader.WrapperFactory(unwrappedVertexType, wrappedVertexType){

                public ElementReader wrap(ElementReader reader) {
                    ElementReader newReader = reader;
                    if (shuffleAxes) {
                        newReader = new AxisShufflingVertexReader(newReader, x, y, z);
                    }
                    if (!unwrappedVertexType.equals(wrappedVertexType)) {
                        newReader = new TypeChangingElementReader(reader, wrappedVertexType);
                    }
                    return newReader;
                }
            });
        }
        this.normalMode = normalMode;
        this.texGenStrategy = texGenStrategyTmp;
        this.plyReader = new RandomPlyReader(new WrappingPlyReader(plyReader, wrappers));
        ArrayList types = new ArrayList();
        for (ElementType type : plyReader.getElementTypes()) {
            types.add(typeMap.get(type.getName()));
        }
        this.elementTypes = Collections.unmodifiableList(types);
    }

    private static ElementType addNormalProps(ElementType sourceType) {
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean foundNX = false;
        boolean foundNY = false;
        boolean foundNZ = false;
        for (Property property : sourceType.getProperties()) {
            if (property.getName().equals("nx")) {
                foundNX = true;
            }
            if (property.getName().equals("ny")) {
                foundNY = true;
            }
            if (property.getName().equals("nz")) {
                foundNZ = true;
            }
            properties.add(property);
        }
        if (foundNX && foundNY && foundNZ) {
            return sourceType;
        }
        if (!foundNX) {
            properties.add(new Property("nx", DataType.DOUBLE));
        }
        if (!foundNY) {
            properties.add(new Property("ny", DataType.DOUBLE));
        }
        if (!foundNZ) {
            properties.add(new Property("nz", DataType.DOUBLE));
        }
        return new ElementType("vertex", properties);
    }

    private static ElementType addTextureProps(ElementType sourceType) {
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean foundU = false;
        boolean foundV = false;
        for (Property property : sourceType.getProperties()) {
            if (property.getName().equals("u")) {
                foundU = true;
            }
            if (property.getName().equals("v")) {
                foundV = true;
            }
            properties.add(property);
        }
        if (foundU && foundV) {
            return sourceType;
        }
        if (!foundU) {
            properties.add(new Property("u", DataType.DOUBLE));
        }
        if (!foundV) {
            properties.add(new Property("v", DataType.DOUBLE));
        }
        return new ElementType("vertex", properties);
    }

    @Override
    public List<ElementType> getElementTypes() {
        return this.elementTypes;
    }

    @Override
    public int getElementCount(String elementType) {
        return this.plyReader.getElementCount(elementType);
    }

    @Override
    public ElementReader nextElementReader() throws IOException {
        RandomElementReader reader = this.plyReader.nextElementReader();
        if (reader == null) {
            return reader;
        }
        if (!reader.getElementType().getName().equals("vertex")) {
            return reader;
        }
        if (this.generateNormals) {
            RandomElementReader faces = this.plyReader.getElementReader("face");
            NormalGenerator generator = new NormalGenerator();
            if (this.normalMode == NormalMode.ADD_NORMALS_CW) {
                generator.setCounterClockwise(false);
            }
            generator.generateNormals(reader.duplicate(), faces);
        }
        RectBounds bounds = new RectBounds();
        if (this.texGenStrategy != null) {
            RandomElementReader boundsReader = reader.duplicate();
            Element element = boundsReader.readElement();
            while (element != null) {
                bounds.addPoint(element.getDouble("x"), element.getDouble("y"), element.getDouble("z"));
                element = boundsReader.readElement();
            }
            RandomElementReader texReader = reader.duplicate();
            Element element2 = texReader.readElement();
            while (element2 != null) {
                this.texGenStrategy.generateCoordinates(element2, bounds);
                element2 = texReader.readElement();
            }
        }
        return reader;
    }

    @Override
    public void close() throws IOException {
        this.plyReader.close();
    }
}

