/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.PlyReader;
import org.smurn.jply.util.BufferedElementReader;
import org.smurn.jply.util.RandomElementReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RandomPlyReader
implements PlyReader {
    private final PlyReader reader;
    private final Map<String, BufferedElementReader> buffer;
    private int nextType = 0;
    private boolean closed = false;

    public RandomPlyReader(PlyReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        this.reader = reader;
        this.buffer = new HashMap<String, BufferedElementReader>();
        for (ElementType type : reader.getElementTypes()) {
            this.buffer.put(type.getName(), null);
        }
    }

    @Override
    public List<ElementType> getElementTypes() {
        return this.reader.getElementTypes();
    }

    @Override
    public int getElementCount(String elementType) {
        try {
            return this.getElementReader(elementType).getCount();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public RandomElementReader getElementReader(String elementType) throws IOException {
        if (elementType == null) {
            throw new NullPointerException("elementType must not be null.");
        }
        if (!this.buffer.containsKey(elementType)) {
            throw new IllegalArgumentException("No such element type.");
        }
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        while (this.buffer.get(elementType) == null) {
            ElementReader eReader = this.reader.nextElementReader();
            BufferedElementReader bReader = new BufferedElementReader(eReader);
            bReader.detach();
            this.buffer.put(eReader.getElementType().getName(), bReader);
        }
        return this.buffer.get(elementType).duplicate();
    }

    @Override
    public RandomElementReader nextElementReader() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        if (this.nextType >= this.getElementTypes().size()) {
            return null;
        }
        String type = this.getElementTypes().get(this.nextType++).getName();
        return this.getElementReader(type);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }
}

