/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v1.nodes;

import java.util.Objects;
import java.util.Optional;
import org.snakeyaml.engine.v1.api.ConstructNode;
import org.snakeyaml.engine.v1.exceptions.Mark;
import org.snakeyaml.engine.v1.nodes.NodeType;
import org.snakeyaml.engine.v1.nodes.Tag;

public abstract class Node {
    private Tag tag;
    private Optional<Mark> startMark;
    protected Optional<Mark> endMark;
    private boolean recursive;
    private Optional<ConstructNode> construct;
    protected boolean resolved;

    public Node(Tag tag, Optional<Mark> startMark, Optional<Mark> endMark) {
        this.setTag(tag);
        this.startMark = startMark;
        this.endMark = endMark;
        this.recursive = false;
        this.resolved = true;
        this.construct = Optional.empty();
    }

    public Tag getTag() {
        return this.tag;
    }

    public Optional<Mark> getEndMark() {
        return this.endMark;
    }

    public abstract NodeType getNodeType();

    public Optional<Mark> getStartMark() {
        return this.startMark;
    }

    public void setTag(Tag tag) {
        Objects.requireNonNull(tag, "tag in a Node is required.");
        this.tag = tag;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Optional<ConstructNode> getConstruct() {
        return this.construct;
    }

    public void setConstruct(ConstructNode construct) {
        this.construct = Optional.of(construct);
    }
}

