/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.IndexedVariables;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableRow2PC;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableCellInfo;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.OIDScope;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOTable
implements MOTable,
MOScope,
SerializableManagedObject {
    private static LogAdapter logger = LogFactory.getLogger((Class)DefaultMOTable.class);
    private OID oid;
    private MOTableIndex indexDef;
    private MOColumn[] columns;
    protected MOTableModel model;
    private boolean isVolatile;
    protected WeakHashMap newRows;
    protected WeakHashMap pendingChanges;
    protected transient Vector moChangeListeners;
    protected transient Vector moTableRowListeners;
    private transient WeakHashMap walkCache;
    private static Comparator columnComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int id1 = o1 instanceof MOColumn ? ((MOColumn)o1).getColumnID() : ((Integer)o1).intValue();
            int id2 = o2 instanceof MOColumn ? ((MOColumn)o2).getColumnID() : ((Integer)o2).intValue();
            return id1 - id2;
        }
    };

    public DefaultMOTable(OID oid, MOTableIndex indexDef, MOColumn[] columns) {
        this(oid, indexDef, columns, new DefaultMOMutableTableModel());
    }

    public DefaultMOTable(OID oid, MOTableIndex indexDef, MOColumn[] columns, MOTableModel model) {
        this.oid = oid;
        this.indexDef = indexDef;
        this.columns = columns;
        this.model = model;
        this.registerColumns();
    }

    private void registerColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].setTable(this);
        }
    }

    public MOTableCellInfo getCellInfo(OID oid) {
        return new CellInfo(oid);
    }

    public int getColumnIndex(int id) {
        int col = Arrays.binarySearch(this.columns, new Integer(id), columnComparator);
        return col;
    }

    public MOColumn getColumn(int index) {
        return this.columns[index];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public MOTableRow createRow(OID index, Variable[] initialValues) {
        if (this.model instanceof MOMutableTableModel) {
            Variable[] values = initialValues;
            if (values.length < this.getColumnCount()) {
                values = this.getDefaultValues();
                System.arraycopy(initialValues, 0, values, 0, initialValues.length);
            }
            MOTableRow row = ((MOMutableTableModel)this.model).createRow(index, values);
            MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, (MOTable)this, row, 1, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() == 0) {
                return row;
            }
        }
        return null;
    }

    public MOTableRow createRow(OID index) {
        return this.createRow(index, this.getDefaultValues());
    }

    public boolean addRow(MOTableRow row) {
        if (this.model instanceof MOMutableTableModel) {
            MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, (MOTable)this, row, 2, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() == 0) {
                ((MOMutableTableModel)this.model).addRow(row);
            }
            return true;
        }
        return false;
    }

    public MOTableRow removeRow(OID index) {
        if (this.model instanceof MOMutableTableModel) {
            MOTableRow row = this.model.getRow(index);
            if (row == null) {
                return null;
            }
            MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, (MOTable)this, row, 3, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() == 0) {
                return ((MOMutableTableModel)this.model).removeRow(index);
            }
        }
        return null;
    }

    public int removeAll() {
        int count = 0;
        if (this.model instanceof MOMutableTableModel) {
            while (this.model.getRowCount() > 0) {
                MOTableRow row = this.model.firstRow();
                if (row == null) continue;
                MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, (MOTable)this, row, 3, true);
                this.fireRowChanged(rowEvent);
                if (rowEvent.getVetoStatus() == 0) {
                    ((MOMutableTableModel)this.model).removeRow(row.getIndex());
                }
                ++count;
            }
        } else {
            count = -1;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(SubRequest request) {
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        MOMutableColumn col = (MOMutableColumn)this.getColumn(cell.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Committing sub-request (" + request.getVariableBinding() + ") for column: " + col));
        }
        MOTableModel mOTableModel = this.model;
        synchronized (mOTableModel) {
            MOMutableTableRow row;
            if (this.hasNewRows(request.getRequest())) {
                row = (MOMutableTableRow)this.getNewRows(request.getRequest()).get(cell.getIndex());
                this.addRow(row);
            } else {
                row = (MOMutableTableRow)this.model.getRow(cell.getIndex());
            }
            Variable oldValue = null;
            if (this.moChangeListeners != null) {
                oldValue = row.getValue(cell.getColumn());
                MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), oldValue, request.getVariableBinding().getVariable(), false);
                this.fireBeforeMOChange(changeEvent);
            }
            ChangeSet changeSet = this.getPendingChangeSet(request, cell.getIndex());
            col.commit(request, row, changeSet, cell.getColumn());
            if (this.moChangeListeners != null) {
                MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), oldValue, request.getVariableBinding().getVariable(), false);
                this.fireAfterMOChange(changeEvent);
            }
            if (this.isChangeSetComplete(request, cell.getIndex(), cell.getColumn())) {
                if (row instanceof MOMutableRow2PC) {
                    ((MOMutableRow2PC)row).commitRow(request, changeSet);
                }
                if (this.moTableRowListeners != null) {
                    MOTableRowEvent rowEvent = new MOTableRowEvent(this, this, row, 4);
                    this.fireRowChanged(rowEvent);
                }
            }
        }
    }

    public final OID getIndexPart(OID anyOID) {
        int offset = this.oid.size() + 1;
        if (anyOID.size() <= offset || !anyOID.startsWith(this.oid)) {
            return null;
        }
        return new OID(anyOID.getValue(), offset, anyOID.size() - offset);
    }

    public OID getCellOID(OID index, int col) {
        OID retval = new OID(this.oid);
        retval.append(this.columns[col].getColumnID());
        retval.append(index);
        return retval;
    }

    private MOTableCellInfo getNextCell(int col, OID indexLowerBound, boolean isLowerBoundIncluded) {
        for (int i = col; i < this.columns.length; ++i) {
            MOTableRow row;
            Iterator it = this.model.tailIterator(indexLowerBound);
            if (!it.hasNext()) {
                if (indexLowerBound == null) {
                    return null;
                }
                indexLowerBound = null;
                isLowerBoundIncluded = true;
                continue;
            }
            if (indexLowerBound != null && !isLowerBoundIncluded && (row = (MOTableRow)it.next()).getIndex().compareTo((Object)indexLowerBound) > 0) {
                return new CellInfo(row.getIndex(), i, this.columns[i].getColumnID(), row);
            }
            indexLowerBound = null;
            isLowerBoundIncluded = true;
            if (!it.hasNext() || (row = (MOTableRow)it.next()) == null) continue;
            return new CellInfo(row.getIndex(), i, this.columns[i].getColumnID(), row);
        }
        return null;
    }

    public OID find(MOScope range) {
        MOTableCellInfo cellInfo = this.findCell(range, null);
        if (cellInfo != null) {
            return cellInfo.getCellOID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MOTableCellInfo findCell(MOScope range, SubRequest request) {
        MOTableModel mOTableModel = this.model;
        synchronized (mOTableModel) {
            OID cellOID;
            MOTableCellInfo next;
            this.update(range, request);
            if (this.model.getRowCount() == 0) {
                return null;
            }
            MOTableCellInfo cellInfo = this.getCellInfo(range.getLowerBound());
            int col = cellInfo.getColumn();
            boolean exactMatch = true;
            if (col < 0) {
                col = -col - 1;
                exactMatch = false;
            }
            if (col >= this.columns.length) {
                return null;
            }
            boolean lowerIncluded = !exactMatch || range.isLowerIncluded();
            RowCacheEntry rowEntry = null;
            if (request != null) {
                rowEntry = this.getWalkCacheEntry(request, cellInfo, lowerIncluded);
            }
            if (rowEntry != null) {
                next = new CellInfo(rowEntry.row.getIndex(), col, cellInfo.getColumnID(), rowEntry.row);
            } else {
                next = this.getNextCell(col, cellInfo.getIndex(), lowerIncluded);
                if (request != null && next != null && next.getColumn() == col) {
                    this.addWalkCacheEntry(request, cellInfo.getIndex(), lowerIncluded, ((CellInfo)next).row);
                }
            }
            if (next != null && range.isCovered(new OIDScope(cellOID = next.getCellOID()))) {
                return next;
            }
        }
        return null;
    }

    private void addWalkCacheEntry(SubRequest request, OID lowerBound, boolean lowerIncluded, MOTableRow row) {
        if (this.walkCache == null) {
            this.walkCache = new WeakHashMap(4);
        }
        this.walkCache.put(request.getRequest(), new RowCacheEntry(row, lowerBound, lowerIncluded));
    }

    private RowCacheEntry getWalkCacheEntry(SubRequest request, MOTableCellInfo cellInfo, boolean lowerIncluded) {
        if (this.walkCache != null) {
            RowCacheEntry entry = (RowCacheEntry)this.walkCache.get(request.getRequest());
            if (entry == null) {
                return null;
            }
            if (entry.searchLowerBound == null && cellInfo.getIndex() == null || entry.searchLowerBound != null && entry.searchLowerBound.equals((Object)cellInfo.getIndex()) && lowerIncluded == entry.searchLowerBoundIncluded) {
                return entry;
            }
        }
        return null;
    }

    public MOScope getScope() {
        return this;
    }

    public Variable getValue(OID cellOID) {
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        if (cell.getIndex() != null && cell.getColumn() >= 0 && cell.getColumn() < this.columns.length) {
            return this.getValue(cell.getIndex(), cell.getColumn());
        }
        return null;
    }

    public Variable getValue(OID index, int col) {
        MOTableRow row = this.model.getRow(index);
        return this.getValue(row, col);
    }

    protected Variable getValue(MOTableRow row, int col) {
        if (row != null && col >= 0 && col < row.size()) {
            return this.columns[col].getValue(row, col);
        }
        return null;
    }

    public void update(MOScope updateScope) {
    }

    protected void update(MOScope range, SubRequest request) {
        Object updateMarker = null;
        if (request != null) {
            updateMarker = request.getRequest().getProcessingUserObject(this.getOID());
        }
        if (updateMarker == null) {
            if (request != null) {
                request.getRequest().setProcessingUserObject(this.getOID(), new Object());
            }
            this.update(range);
        }
    }

    public void get(SubRequest request) {
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        if (cell.getIndex() != null && cell.getColumn() >= 0 && cell.getColumn() < this.columns.length) {
            this.update(request.getScope(), request);
            MOColumn col = this.getColumn(cell.getColumn());
            MOTableRow row = this.model.getRow(cell.getIndex());
            if (row == null) {
                request.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
            } else if (col != null) {
                col.get(request, row, cell.getColumn());
            } else {
                request.getStatus().setErrorStatus(6);
            }
        } else if (cell.getColumn() >= 0) {
            request.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
        } else {
            request.getVariableBinding().setVariable((Variable)Null.noSuchObject);
        }
        request.completed();
    }

    public boolean next(SubRequest request) {
        MOTableCellInfo nextCell;
        DefaultMOScope scope = new DefaultMOScope(request.getScope());
        while ((nextCell = this.findCell(scope, request)) != null) {
            if (this.columns[nextCell.getColumn()].getAccess().isAccessibleForRead()) {
                Variable value = nextCell instanceof CellInfo && ((CellInfo)nextCell).getRow() != null ? this.getValue(((CellInfo)nextCell).getRow(), nextCell.getColumn()) : this.getValue(nextCell.getIndex(), nextCell.getColumn());
                if (value == null) {
                    scope.setLowerBound(nextCell.getCellOID());
                    scope.setLowerIncluded(false);
                    continue;
                }
                request.getVariableBinding().setOid(nextCell.getCellOID());
                request.getVariableBinding().setVariable(value);
                request.completed();
                return true;
            }
            if (nextCell.getColumn() + 1 < this.getColumnCount()) {
                OID nextColOID = new OID(this.getOID());
                nextColOID.append(this.columns[nextCell.getColumn() + 1].getColumnID());
                scope.setLowerBound(nextColOID);
                scope.setLowerIncluded(false);
                continue;
            }
            return false;
        }
        return false;
    }

    public void prepare(SubRequest request) {
        block17: {
            OID cellOID = request.getVariableBinding().getOid();
            MOTableCellInfo cell = this.getCellInfo(cellOID);
            if (cell.getIndex() == null) {
                request.getStatus().setErrorStatus(18);
                return;
            }
            if (cell.getColumn() >= 0 && cell.getColumn() < this.columns.length) {
                MOColumn col = this.getColumn(cell.getColumn());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Preparing sub-request (" + request.getVariableBinding() + ")" + " for column: " + col));
                }
                if (col instanceof MOMutableColumn && col.getAccess().isAccessibleForWrite()) {
                    MOMutableColumn mcol = (MOMutableColumn)col;
                    if (this.getIndexDef().isValidIndex(cell.getIndex())) {
                        MOTableRow row = this.model.getRow(cell.getIndex());
                        if (row == null) {
                            row = (MOTableRow)this.getNewRows(request.getRequest()).get(cell.getIndex());
                        }
                        if (row != null) {
                            this.prepare(request, cell, mcol, row, false);
                            request.completed();
                            return;
                        }
                        if (this.model instanceof MOMutableTableModel) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Trying to create new row '" + cell.getIndex() + "'"));
                            }
                            MOMutableTableModel mmodel = (MOMutableTableModel)this.model;
                            try {
                                row = this.createRow(request, cell, mmodel);
                                if (row == null) {
                                    request.getStatus().setErrorStatus(11);
                                    break block17;
                                }
                                this.prepare(request, cell, mcol, row, true);
                                request.completed();
                            }
                            catch (UnsupportedOperationException ex) {
                                request.getStatus().setErrorStatus(11);
                            }
                        } else {
                            request.getStatus().setErrorStatus(11);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invalid index '" + cell.getIndex() + "' for row creation in table " + this.getID()));
                        }
                        request.getStatus().setErrorStatus(11);
                    }
                } else {
                    request.getStatus().setErrorStatus(17);
                }
            } else {
                request.getStatus().setErrorStatus(11);
            }
        }
    }

    private MOTableRow createRow(SubRequest request, MOTableCellInfo cell, MOMutableTableModel mmodel) throws UnsupportedOperationException {
        MOColumn col = this.getColumn(cell.getColumn());
        if (!col.getAccess().isAccessibleForCreate()) {
            return null;
        }
        Variable[] initialValues = new Variable[this.getColumnCount()];
        this.getChangesFromRequest(cell.getIndex(), null, request, initialValues, true, true);
        MOTableRow row = mmodel.createRow(cell.getIndex(), initialValues);
        this.getNewRows(request.getRequest()).put(row.getIndex(), row);
        return row;
    }

    private void prepare(SubRequest request, MOTableCellInfo cell, MOMutableColumn mcol, MOTableRow row, boolean creation) {
        ChangeSet changeSet;
        if (this.moChangeListeners != null) {
            MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), creation ? null : row.getValue(cell.getColumn()), request.getVariableBinding().getVariable(), true);
            this.fireBeforePrepareMOChange(changeEvent);
            if (changeEvent.getDenyReason() != 0) {
                request.getStatus().setErrorStatus(changeEvent.getDenyReason());
            }
        }
        if ((changeSet = this.getPendingChangeSet(request, cell.getIndex())) == null) {
            changeSet = this.addPendingChanges(request, row, creation);
        }
        if (this.moTableRowListeners != null && !request.hasError() && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
            MOTableRowEvent rowEvent = new MOTableRowEvent(this, this, row, changeSet, creation ? 1 : 0, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() != 0) {
                if (rowEvent.getVetoColumn() >= 0) {
                    int colID = this.columns[rowEvent.getVetoColumn()].getColumnID();
                    OID prefix = new OID(this.getOID());
                    prefix.append(colID);
                    SubRequest r = request.getRequest().find(prefix);
                    if (r != null) {
                        r.getStatus().setErrorStatus(rowEvent.getVetoStatus());
                    } else {
                        request.getRequest().setErrorStatus(rowEvent.getVetoStatus());
                    }
                } else {
                    request.getRequest().setErrorStatus(rowEvent.getVetoStatus());
                }
            }
        }
        if (request.getStatus().getErrorStatus() == 0) {
            mcol.prepare(request, row, changeSet, cell.getColumn());
            MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), row.getValue(cell.getColumn()), request.getVariableBinding().getVariable(), true);
            this.fireAfterPrepareMOChange(changeEvent);
            if (changeEvent.getDenyReason() != 0) {
                request.getStatus().setErrorStatus(changeEvent.getDenyReason());
            } else if (row instanceof MOMutableRow2PC && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
                ((MOMutableRow2PC)row).prepareRow(request, changeSet);
            }
        }
    }

    protected int getChangesFromRequest(OID index, MOTableRow row, SubRequest request, Variable[] values, boolean setDefaultValues, boolean newRow) {
        int lastChangedColumn = -1;
        if (setDefaultValues) {
            for (int i = 0; i < values.length && i < this.getColumnCount(); ++i) {
                if (!(this.columns[i] instanceof MOMutableColumn)) continue;
                values[i] = ((MOMutableColumn)this.columns[i]).getDefaultValue();
            }
        }
        Request req = request.getRequest();
        Iterator it = req.iterator();
        while (it.hasNext()) {
            Variable v;
            int col;
            SubRequest sreq = (SubRequest)it.next();
            OID id = sreq.getVariableBinding().getOid();
            MOTableCellInfo cellInfo = this.getCellInfo(id);
            if (!index.equals((Object)cellInfo.getIndex()) || (col = cellInfo.getColumn()) < 0 || col >= values.length || (v = sreq.getVariableBinding().getVariable()) == null || row != null && !newRow && row.size() > col && v.equals(row.getValue(col))) continue;
            values[col] = v;
            lastChangedColumn = col;
        }
        return lastChangedColumn;
    }

    protected boolean hasNewRows(Object key) {
        return this.newRows != null && this.newRows.get(key) != null;
    }

    protected Map getNewRows(Object key) {
        HashMap rowMap;
        if (this.newRows == null) {
            this.newRows = new WeakHashMap(4);
        }
        if ((rowMap = (HashMap)this.newRows.get(key)) == null) {
            rowMap = new HashMap(5);
            this.newRows.put(key, rowMap);
        }
        return rowMap;
    }

    protected synchronized boolean isChangeSetComplete(SubRequest subRequest, OID index, int column) {
        ChangeSet changeSet = this.getPendingChangeSet(subRequest, index);
        if (changeSet != null) {
            return changeSet.getLastChangedColumn() == column;
        }
        return true;
    }

    protected synchronized ChangeSet addPendingChanges(SubRequest subRequest, MOTableRow row, boolean newRow) {
        HashMap<OID, ChangeSet> rowMap;
        if (this.pendingChanges == null) {
            this.pendingChanges = new WeakHashMap(4);
        }
        if ((rowMap = (HashMap<OID, ChangeSet>)this.pendingChanges.get(subRequest.getRequest())) == null) {
            rowMap = new HashMap<OID, ChangeSet>(5);
            this.pendingChanges.put(subRequest.getRequest(), rowMap);
        }
        Variable[] values = new Variable[this.getColumnCount()];
        int lastChangedColumn = this.getChangesFromRequest(row.getIndex(), row, subRequest, values, newRow, newRow);
        ChangeSet changeSet = new ChangeSet(row.getIndex(), values);
        changeSet.lastChangedColumn = lastChangedColumn;
        rowMap.put(row.getIndex(), changeSet);
        return changeSet;
    }

    protected ChangeSet getPendingChangeSet(SubRequest subRequest, OID index) {
        Map rowMap;
        if (this.pendingChanges != null && (rowMap = (Map)this.pendingChanges.get(subRequest.getRequest())) != null) {
            return (ChangeSet)rowMap.get(index);
        }
        return null;
    }

    public void cleanup(SubRequest request) {
        MOMutableTableRow row;
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        if (cell.getIndex() == null || cell.getColumn() < 0) {
            return;
        }
        MOColumn col = this.getColumn(cell.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning-up sub-request (" + request.getVariableBinding() + ") for column: " + col));
        }
        if ((row = (MOMutableTableRow)this.model.getRow(cell.getIndex())) != null && col instanceof MOMutableColumn) {
            ((MOMutableColumn)col).cleanup(request, row, cell.getColumn());
        }
        if (row instanceof MOMutableRow2PC && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
            ((MOMutableRow2PC)row).cleanupRow(request, this.getPendingChangeSet(request, row.getIndex()));
        }
        request.completed();
    }

    public void undo(SubRequest request) {
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        MOMutableColumn col = (MOMutableColumn)this.getColumn(cell.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Undoing sub-request (" + request.getVariableBinding() + ") for column: " + col));
        }
        if (this.hasNewRows(request.getRequest())) {
            ((MOMutableTableModel)this.model).removeRow(cell.getIndex());
        } else {
            MOMutableTableRow row = (MOMutableTableRow)this.model.getRow(cell.getIndex());
            if (row != null) {
                col.undo(request, row, cell.getColumn());
            }
            if (row instanceof MOMutableRow2PC && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
                ((MOMutableRow2PC)row).undoRow(request, this.getPendingChangeSet(request, row.getIndex()));
            }
        }
    }

    public OID getOID() {
        return this.oid;
    }

    public void setModel(MOTableModel model) {
        this.model = model;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public MOTableModel getModel() {
        return this.model;
    }

    public MOColumn[] getColumns() {
        return this.columns;
    }

    public MOTableIndex getIndexDef() {
        return this.indexDef;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public OID getLowerBound() {
        return this.oid;
    }

    public OID getUpperBound() {
        OID upperBound = new OID(this.oid);
        int lastID = this.oid.size() - 1;
        upperBound.set(lastID, this.oid.get(lastID) + 1);
        return upperBound;
    }

    public boolean isLowerIncluded() {
        return false;
    }

    public boolean isUpperIncluded() {
        return false;
    }

    public boolean isCovered(MOScope other) {
        return DefaultMOScope.covers(this, other);
    }

    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    public synchronized void addMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners == null) {
            this.moChangeListeners = new Vector(2);
        }
        this.moChangeListeners.add(l);
    }

    public synchronized void removeMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners != null) {
            this.moChangeListeners.remove(l);
        }
    }

    protected void fireBeforePrepareMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOChangeListener)listeners.elementAt(i)).beforePrepareMOChange(changeEvent);
            }
        }
    }

    protected void fireAfterPrepareMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOChangeListener)listeners.elementAt(i)).afterPrepareMOChange(changeEvent);
            }
        }
    }

    protected void fireBeforeMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOChangeListener)listeners.elementAt(i)).beforeMOChange(changeEvent);
            }
        }
    }

    protected void fireAfterMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOChangeListener)listeners.elementAt(i)).afterMOChange(changeEvent);
            }
        }
    }

    public synchronized void addMOTableRowListener(MOTableRowListener l) {
        if (this.moTableRowListeners == null) {
            this.moTableRowListeners = new Vector(2);
        }
        this.moTableRowListeners.add(l);
    }

    public synchronized void removeMOTableRowListener(MOTableRowListener l) {
        if (this.moTableRowListeners != null) {
            this.moTableRowListeners.remove(l);
        }
    }

    protected void fireRowChanged(MOTableRowEvent event) {
        if (this.moTableRowListeners != null) {
            Vector listeners = this.moTableRowListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOTableRowListener)listeners.elementAt(i)).rowChanged(event);
            }
        }
    }

    public OID getID() {
        return this.getLowerBound();
    }

    public void load(MOInput input) throws IOException {
        if (input.getImportMode() == 1) {
            int count = this.removeAll();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed " + count + " rows from " + this.getID() + " because importing with a REPLACE import mode"));
            }
        }
        Sequence seq = input.readSequence();
        for (int i = 0; i < seq.getSize(); ++i) {
            IndexedVariables rowValues = input.readIndexedVariables();
            boolean rowExists = this.model.containsRow(rowValues.getIndex());
            if (input.getImportMode() == 4 && rowExists) {
                logger.debug((Object)("Row '" + rowValues.getIndex() + "' not imported because it already exists in table " + this.getID() + " and import mode is CREATE"));
                continue;
            }
            if (rowExists) {
                this.removeRow(rowValues.getIndex());
            }
            if (!rowExists && input.getImportMode() != 4 && input.getImportMode() != 1 && input.getImportMode() != 2) continue;
            MOTableRow row = null;
            try {
                row = this.createRow(rowValues.getIndex(), rowValues.getValues());
            }
            catch (UnsupportedOperationException uoex) {
                logger.debug((Object)("Could not create row by row factory: " + uoex.getMessage()));
            }
            if (row == null) {
                row = new DefaultMOTableRow(rowValues.getIndex(), rowValues.getValues());
                this.fireRowChanged(new MOTableRowEvent(this, this, row, 1));
            }
            this.addRow(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(MOOutput output) throws IOException {
        Iterator it;
        LinkedList<IndexedVariables> rowsToSave = new LinkedList<IndexedVariables>();
        MOTableModel mOTableModel = this.model;
        synchronized (mOTableModel) {
            it = this.model.iterator();
            while (it.hasNext()) {
                MOTableRow row = (MOTableRow)it.next();
                boolean volatileRow = false;
                for (int i = 0; i < this.columns.length; ++i) {
                    if (!this.columns[i].isVolatile(row, i)) continue;
                    volatileRow = true;
                    break;
                }
                if (volatileRow) continue;
                Variable[] values = this.getPersistentValues(row);
                IndexedVariables rowValues = new IndexedVariables(row.getIndex(), values);
                rowsToSave.add(rowValues);
            }
        }
        Sequence group = new Sequence(rowsToSave.size());
        output.writeSequence(group);
        it = rowsToSave.iterator();
        while (it.hasNext()) {
            IndexedVariables rowValues = (IndexedVariables)it.next();
            output.writeIndexedVariables(rowValues);
        }
    }

    protected Variable[] getPersistentValues(MOTableRow row) {
        Variable[] values = new Variable[row.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = row.getValue(i);
        }
        return values;
    }

    public Variable[] getDefaultValues() {
        Variable[] values = new Variable[this.getColumnCount()];
        for (int i = 0; i < values.length; ++i) {
            if (!(this.columns[i] instanceof MOMutableColumn)) continue;
            values[i] = ((MOMutableColumn)this.columns[i]).getDefaultValue();
        }
        return values;
    }

    public String toString() {
        return "DefaultMOTable[id=" + this.getID() + ",index=" + this.getIndexDef() + ",columns=" + Arrays.asList(this.getColumns()) + "]";
    }

    public boolean covers(OID oid) {
        return this.isCovered(new DefaultMOScope(oid, true, oid, true));
    }

    private static class RowCacheEntry {
        private MOTableRow row;
        private OID searchLowerBound;
        private boolean searchLowerBoundIncluded;

        RowCacheEntry(MOTableRow row, OID searchLowerBound, boolean searchLowerBoundIncluded) {
            this.row = row;
            this.searchLowerBound = searchLowerBound;
            this.searchLowerBoundIncluded = searchLowerBoundIncluded;
        }
    }

    class CellInfo
    implements MOTableCellInfo {
        private OID index;
        private int id = 0;
        private int col = -1;
        private MOTableRow row;

        public CellInfo(OID oid) {
            this.index = DefaultMOTable.this.getIndexPart(oid);
            if (oid.size() > DefaultMOTable.this.oid.size() && oid.startsWith(DefaultMOTable.this.oid)) {
                this.id = oid.get(DefaultMOTable.this.oid.size());
            }
        }

        public CellInfo(OID index, int column, int columnID) {
            this.index = index;
            this.col = column;
            this.id = columnID;
        }

        public CellInfo(OID index, int column, int columnID, MOTableRow row) {
            this(index, column, columnID);
            this.row = row;
        }

        public OID getIndex() {
            return this.index;
        }

        public int getColumn() {
            if (this.col < 0) {
                this.col = DefaultMOTable.this.getColumnIndex(this.id);
            }
            return this.col;
        }

        public int getColumnID() {
            return this.id;
        }

        public OID getCellOID() {
            return DefaultMOTable.this.getCellOID(this.index, this.col);
        }

        public MOTableRow getRow() {
            return this.row;
        }
    }

    class CellProxy
    implements ManagedObject {
        private MOTableCellInfo cellInfo;
        private MOScope scope;

        public CellProxy(MOTableCellInfo cellInfo) {
            this.cellInfo = cellInfo;
            this.scope = new OIDScope(cellInfo.getCellOID());
        }

        public MOScope getScope() {
            return this.scope;
        }

        public OID find(MOScope range) {
            if (range.isCovered(this.scope)) {
                return this.cellInfo.getCellOID();
            }
            return null;
        }

        public void get(SubRequest request) {
            DefaultMOTable.this.get(request);
        }

        public boolean next(SubRequest request) {
            return DefaultMOTable.this.next(request);
        }

        public void prepare(SubRequest request) {
            DefaultMOTable.this.prepare(request);
        }

        public void commit(SubRequest request) {
            DefaultMOTable.this.commit(request);
        }

        public void undo(SubRequest request) {
            DefaultMOTable.this.undo(request);
        }

        public void cleanup(SubRequest request) {
            DefaultMOTable.this.cleanup(request);
        }

        public MOTable getTable() {
            return DefaultMOTable.this;
        }
    }

    public static class ChangeSet
    implements MOTableRow {
        private OID index;
        private Variable[] values;
        private int lastChangedColumn = -1;

        public ChangeSet(OID index, Variable[] values) {
            this.index = index;
            this.values = values;
        }

        public OID getIndex() {
            return this.index;
        }

        public int getLastChangedColumn() {
            return this.lastChangedColumn;
        }

        public void setValue(int column, Variable value) {
            this.values[column] = value;
            this.lastChangedColumn = column;
        }

        public Variable getValue(int column) {
            return this.values[column];
        }

        public MOTableRow getBaseRow() {
            return null;
        }

        public int size() {
            return this.values.length;
        }

        public void setBaseRow(MOTableRow baseRow) {
            throw new UnsupportedOperationException();
        }
    }
}

