/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpAdminString
extends MOMutableColumn {
    private int minLength = 0;
    private int maxLength = 255;

    public SnmpAdminString(int columnID, MOAccess access, Variable defaultValue, boolean mutableInService) {
        super(columnID, 4, access, defaultValue, mutableInService);
    }

    public SnmpAdminString(int columnID, MOAccess access, Variable defaultValue, boolean mutableInService, int minLength, int maxLength) {
        super(columnID, 4, access, defaultValue, mutableInService);
        this.setMinLength(minLength);
        this.setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public synchronized int validate(Variable newValue, Variable oldValue) {
        OctetString os = (OctetString)newValue;
        if (os.length() < this.minLength || os.length() > this.maxLength) {
            return 8;
        }
        return super.validate(newValue, oldValue);
    }
}

