/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.Variable;

public class MOColumn<V extends Variable>
implements Comparable {
    private int columnID;
    private int syntax;
    private MOAccess access;
    private MOTable table;

    public MOColumn(int columnID, int syntax) {
        this.columnID = columnID;
        this.syntax = syntax;
        this.access = MOAccessImpl.ACCESS_READ_ONLY;
    }

    public MOColumn(int columnID, int syntax, MOAccess access) {
        this.columnID = columnID;
        this.syntax = syntax;
        if (access == null) {
            throw new NullPointerException("Access must be specified");
        }
        this.access = access;
    }

    public void setColumnID(int columnID) {
        this.columnID = columnID;
    }

    public void setSyntax(int syntax) {
        this.syntax = syntax;
    }

    public void setAccess(MOAccess access) {
        this.access = access;
    }

    public <R extends MOTableRow> void setTable(MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>> table) {
        this.table = table;
    }

    public int getColumnID() {
        return this.columnID;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public MOAccess getAccess() {
        return this.access;
    }

    public MOTable getTable() {
        return this.table;
    }

    public V getValue(MOTableRow row, int column) {
        return row.getValue(column);
    }

    public boolean isVolatile(MOTableRow<V> row, int column) {
        return false;
    }

    public Variable getRestoreValue(Variable[] rowValues, int column) {
        return rowValues[column];
    }

    public Variable getStoreValue(MOTableRow row, int column) {
        return row.getValue(column);
    }

    public int compareTo(Object column) {
        return this.columnID - ((MOColumn)column).getColumnID();
    }

    public String toString() {
        return this.getClass().getName() + "[columnID=" + this.getColumnID() + ",syntax=" + this.getSyntax() + "]";
    }

    public void get(SubRequest subRequest, MOTableRow row, int column) {
        if (this.getAccess().isAccessibleForRead()) {
            V value = this.getValue(row, column);
            if (value != null) {
                subRequest.getVariableBinding().setVariable((Variable)value.clone());
            } else {
                subRequest.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
            }
            subRequest.completed();
        } else {
            subRequest.getStatus().setErrorStatus(6);
        }
    }
}

