/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOQueryWithSource;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.NotificationTask;
import org.snmp4j.agent.ProxyForwardRequest;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.ProxyMap;
import org.snmp4j.agent.RequestHandler;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestFactory;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.agent.util.TemporaryList;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class CommandProcessor
implements CommandResponder,
NotificationOriginator {
    private static final LogAdapter logger = LogFactory.getLogger(CommandProcessor.class);
    private static final int MAX_INTERNAL_REQUEST_TIMEOUT = 300000;
    protected WorkerPool threadPool = null;
    protected VACM vacm = null;
    protected Vector<MOServer> moServers;
    protected List<OctetString> ownContextEngineIDs = new ArrayList<OctetString>(2);
    protected final Vector<RequestHandler<SnmpRequest>> pduHandler = new Vector();
    protected TemporaryList<Request> requestList;
    protected RequestFactory<CommandResponderEvent, PDU, SnmpRequest> requestFactory;
    protected NotificationOriginator notificationOriginator;
    protected ProxyMap proxyForwarder;
    protected CoexistenceInfoProvider coexistenceProvider;
    private transient Vector<CounterListener> counterListeners;

    public CommandProcessor(OctetString contextEngineID) {
        this.ownContextEngineIDs.add(contextEngineID);
        this.ownContextEngineIDs.add(MPv3.LOCAL_ENGINE_ID);
        this.moServers = new Vector();
        this.requestList = new TemporaryList(300000);
        this.pduHandler.add(new GetHandler());
        this.pduHandler.add(new GetNextHandler());
        this.pduHandler.add(new SetHandler());
        this.pduHandler.add(new GetBulkHandler());
        this.requestFactory = new DefaultRequestFactory();
    }

    public void setInternalRequestTimeout(int timeoutMillis) {
        this.requestList.setTimeout(timeoutMillis);
    }

    public int getInternalRequestTimeout() {
        return this.requestList.getTimeout();
    }

    public void processPdu(CommandResponderEvent event) {
        if (event.getPDU() != null) {
            CoexistenceInfo cinfo = null;
            OctetString sname = new OctetString(event.getSecurityName());
            if (event.getPDU() instanceof ScopedPDU) {
                ScopedPDU spdu = (ScopedPDU)event.getPDU();
                cinfo = new CoexistenceInfo(sname, spdu.getContextEngineID(), spdu.getContextName());
            } else if (this.coexistenceProvider != null) {
                CoexistenceInfo[] cinfos = this.coexistenceProvider.getCoexistenceInfo(sname);
                if (cinfos != null && cinfos.length > 0) {
                    for (CoexistenceInfo cinfo1 : cinfos) {
                        if (!this.coexistenceProvider.passesFilter(event.getPeerAddress(), cinfo1)) continue;
                        cinfo = cinfo1;
                        break;
                    }
                    if (cinfo == null) {
                        logger.warn((Serializable)((Object)("Access attempt from " + event.getPeerAddress() + " denied because of source address filtering")));
                        this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpInBadCommunityNames));
                        return;
                    }
                    event.setMaxSizeResponsePDU(cinfo.getMaxMessageSize());
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info((CharSequence)("Community name '" + sname + "' not found in SNMP-COMMUNITY-MIB"));
                    }
                    this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpInBadCommunityNames));
                    return;
                }
            }
            if (cinfo == null || this.ownContextEngineIDs.contains(cinfo.getContextEngineID())) {
                event.setProcessed(true);
                Command command = new Command(event, cinfo);
                if (this.threadPool != null) {
                    this.threadPool.execute((WorkerTask)command);
                } else {
                    command.run();
                }
            } else if (this.proxyForwarder != null) {
                ProxyForwardRequest request = new ProxyForwardRequest(event, cinfo);
                ProxyForwarder proxy = this.proxyForwarder.get(cinfo.getContextEngineID(), request.getProxyType());
                ProxyCommand command = new ProxyCommand(proxy, request);
                if (proxy != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Processsing proxy request with proxy forwarder " + proxy)));
                    }
                    if (this.threadPool != null) {
                        this.threadPool.execute((WorkerTask)command);
                    } else {
                        command.run();
                    }
                } else {
                    this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpProxyDrops));
                }
            } else {
                this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpSilentDrops));
            }
        }
    }

    public void setThreadPool(WorkerPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setWorkerPool(WorkerPool threadPool) {
        this.threadPool = threadPool;
    }

    public VACM getVacm() {
        return this.vacm;
    }

    public void setVacm(VACM vacm) {
        this.vacm = vacm;
    }

    public OctetString getContextEngineID() {
        return this.ownContextEngineIDs.get(0);
    }

    public void setContextEngineID(OctetString contextEngineID) {
        this.ownContextEngineIDs.set(0, contextEngineID);
    }

    @Override
    public Object notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        return this.notify(context, notificationID, null, vbs);
    }

    @Override
    public Object notify(OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) {
        if (this.notificationOriginator != null) {
            NotificationTask notifyTask = new NotificationTask(this.notificationOriginator, context, notificationID, sysUpTime, vbs);
            if (this.threadPool != null) {
                this.threadPool.execute((WorkerTask)notifyTask);
                return notifyTask;
            }
            notifyTask.run();
            return notifyTask.getResponses();
        }
        logger.warn((Serializable)((Object)("Could not sent notification '" + notificationID + "'=" + Arrays.asList(vbs) + " because NotificationOriginator not set")));
        return null;
    }

    public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
        this.notificationOriginator = notificationOriginator;
    }

    public void setCoexistenceProvider(CoexistenceInfoProvider coexistenceProvider) {
        this.coexistenceProvider = coexistenceProvider;
    }

    public ProxyForwarder addProxyForwarder(ProxyForwarder proxyForwarder, OctetString contextEngineID, int proxyType) {
        if (this.proxyForwarder == null) {
            this.proxyForwarder = new ProxyMap();
        }
        return this.proxyForwarder.add(proxyForwarder, contextEngineID, proxyType);
    }

    public ProxyForwarder removeProxyForwarder(OctetString contextEngineID, int proxyType) {
        if (this.proxyForwarder != null) {
            return this.proxyForwarder.remove(contextEngineID, proxyType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestHandler<SnmpRequest> getHandler(int pduType) {
        Vector<RequestHandler<SnmpRequest>> vector = this.pduHandler;
        synchronized (vector) {
            for (RequestHandler<SnmpRequest> handler : this.pduHandler) {
                if (!handler.isSupported(pduType)) continue;
                return handler;
            }
        }
        return null;
    }

    protected void dispatchCommand(CommandResponderEvent command, CoexistenceInfo cinfo) {
        RequestHandler<SnmpRequest> handler = this.getHandler(command.getPDU().getType());
        if (handler != null) {
            this.processRequest(command, cinfo, handler);
        } else {
            this.sendUnknownPDUHandlersReport(command);
        }
    }

    private void sendUnknownPDUHandlersReport(CommandResponderEvent command) {
        logger.info((CharSequence)("No PDU handler found for request " + command));
        CounterEvent counter = new CounterEvent((Object)this, SnmpConstants.snmpUnknownPDUHandlers);
        this.fireIncrementCounter(counter);
        if (command.getMessageProcessingModel() == 3 && command.getPDU() instanceof ScopedPDU) {
            ScopedPDU request = (ScopedPDU)command.getPDU();
            ScopedPDU report = new ScopedPDU();
            report.setContextEngineID(request.getContextEngineID());
            report.setContextName(request.getContextName());
            report.setType(-88);
            report.add(new VariableBinding(counter.getOid(), counter.getCurrentValue()));
            this.sendResponse(command, (PDU)report);
        } else {
            PDU resp = (PDU)command.getPDU().clone();
            resp.setErrorStatus(5);
            this.sendResponse(command, resp);
        }
    }

    protected void processRequest(CommandResponderEvent command, CoexistenceInfo cinfo, RequestHandler<SnmpRequest> handler) {
        SnmpRequest req = this.requestFactory.createRequest(command, cinfo);
        this.requestList.add(req);
        MOServer server = null;
        OctetString context = req.getContext();
        OctetString viewName = this.getViewName(command, cinfo, req.getViewType());
        if (viewName == null) {
            this.setAuthorizationError(req, 2);
        } else {
            req.setViewName(viewName);
            server = this.getServer(context);
            this.processRequest(server, handler, req);
        }
        this.finalizeRequest(command, req, server);
    }

    protected void reprocessRequest(MOServer server, SnmpRequest req) {
        RequestHandler<SnmpRequest> handler = this.getHandler(((CommandResponderEvent)req.getSource()).getPDU().getType());
        if (handler != null) {
            req.resetProcessedStatus();
            req.incReprocessCounter();
            this.processRequest(server, handler, req);
        } else {
            this.sendUnknownPDUHandlersReport((CommandResponderEvent)req.getSource());
        }
    }

    protected <R extends Request<Source, Response, ? extends SubRequest>, Source, Response> void processRequest(MOServer server, RequestHandler<R> handler, R req) {
        if (server == null) {
            logger.error((Serializable)((Object)("No server for " + req.getContext() + " found -> request cannot be processed")));
            req.setErrorStatus(5);
        } else {
            handler.processPdu(req, server);
        }
    }

    protected void finalizeRequest(CommandResponderEvent command, SnmpRequest req, MOServer server) {
        if (req.isComplete()) {
            this.requestList.remove(req);
            this.sendResponse(command, req.getResponse());
            if (server != null) {
                this.release(server, req);
            }
        }
    }

    protected void release(MOServer server, SnmpRequest req) {
        Iterator<SnmpRequest.SnmpSubRequest> it = req.iterator();
        while (it.hasNext()) {
            SubRequest sreq = it.next();
            if (sreq.getTargetMO() == null) continue;
            server.unlock(req, sreq.getTargetMO());
        }
    }

    protected void sendResponse(CommandResponderEvent requestEvent, PDU response) {
        MessageDispatcher disp = requestEvent.getMessageDispatcher();
        try {
            if (response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                if (response.getType() != -88) {
                    if (requestEvent.getPDU().getType() == -91) {
                        while (response.size() > 0 && response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                            response.trim();
                        }
                    } else {
                        response.clear();
                        response.setRequestID(requestEvent.getPDU().getRequestID());
                        response.setErrorStatus(1);
                    }
                }
                if (response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                    this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpSilentDrops));
                    return;
                }
            }
            StatusInformation status = new StatusInformation();
            StateReference stateRef = requestEvent.getStateReference();
            if (stateRef == null) {
                logger.warn((Serializable)((Object)("No state reference available for requestEvent=" + requestEvent + ". Cannot return response=" + response)));
            } else {
                stateRef.setTransportMapping(requestEvent.getTransportMapping());
                disp.returnResponsePdu(requestEvent.getMessageProcessingModel(), requestEvent.getSecurityModel(), requestEvent.getSecurityName(), requestEvent.getSecurityLevel(), response, requestEvent.getMaxSizeResponsePDU(), requestEvent.getStateReference(), status);
            }
        }
        catch (MessageException ex) {
            logger.error((CharSequence)("Failed to send response to request " + requestEvent), (Throwable)ex);
        }
    }

    protected void setAuthorizationError(Request req, int vacmStatus) {
        if (req.size() > 0) {
            SubRequest sreq = (SubRequest)req.iterator().next();
            sreq.getStatus().setErrorStatus(16);
        } else {
            req.setErrorStatus(16);
        }
    }

    public void addPduHandler(RequestHandler<SnmpRequest> handler) {
        this.pduHandler.add(handler);
    }

    public void removePduHandler(RequestHandler handler) {
        this.pduHandler.remove(handler);
    }

    public void addMOServer(MOServer server) {
        this.moServers.add(server);
    }

    public void removeMOServer(MOServer server) {
        this.moServers.remove(server);
    }

    public MOServer getServer(OctetString context) {
        for (MOServer s : this.moServers) {
            if (!s.isContextSupported(context)) continue;
            return s;
        }
        return null;
    }

    public TemporaryList<Request> getRequestList() {
        return this.requestList;
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public ProxyMap getProxyForwarder() {
        return this.proxyForwarder;
    }

    public CoexistenceInfoProvider getCoexistenceProvider() {
        return this.coexistenceProvider;
    }

    protected OctetString getViewName(CommandResponderEvent req, CoexistenceInfo cinfo, int viewType) {
        return this.vacm.getViewName(cinfo.getContextName(), cinfo.getSecurityName(), req.getSecurityModel(), req.getSecurityLevel(), viewType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNextSubRequest(SnmpRequest request, MOServer server, OctetString context, SubRequest sreq) throws NoSuchElementException {
        DefaultMOContextScope scope = (DefaultMOContextScope)sreq.getScope();
        MOQuery query = sreq.getQuery();
        if (query == null) {
            query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName(), false, request);
            sreq.setQuery(query);
        }
        LockRequest lockRequest = new LockRequest(request, this.requestList.getTimeout());
        while (!sreq.getStatus().isProcessed()) {
            ManagedObject mo = server.lookup(query, lockRequest);
            if (mo == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("EndOfMibView at scope=" + scope + " and query " + query)));
                }
                sreq.getVariableBinding().setVariable((Variable)Null.endOfMibView);
                sreq.getStatus().setPhaseComplete(true);
                continue;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Processing NEXT query " + query + " with " + mo + " sub-request with index " + sreq.getIndex())));
                }
                boolean counter64Skip = false;
                if (mo.next(sreq) && !(counter64Skip = request.getMessageProcessingModel() == 0 && sreq.getVariableBinding().getSyntax() == 70)) continue;
                sreq.getVariableBinding().setVariable((Variable)Null.instance);
                if (counter64Skip) {
                    scope.lowerBound = sreq.getVariableBinding().getOid();
                    scope.lowerIncluded = false;
                    sreq.getStatus().setProcessed(false);
                    continue;
                }
                scope.substractScope(mo.getScope());
                query.substractScope(mo.getScope());
            }
            catch (Exception moex) {
                if (logger.isDebugEnabled()) {
                    moex.printStackTrace();
                }
                logger.error((CharSequence)("Exception occurred while executing NEXT query: " + moex.getMessage()), (Throwable)moex);
                if (sreq.getStatus().getErrorStatus() == 0) {
                    sreq.getStatus().setErrorStatus(5);
                }
                if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                throw new RuntimeException(moex);
            }
            finally {
                this.unlockManagedObjectIfLockedByLookup(server, mo, lockRequest);
            }
        }
    }

    protected void unlockManagedObjectIfLockedByLookup(MOServer server, ManagedObject mo, LockRequest lockRequest) {
        switch (lockRequest.getLockRequestStatus()) {
            case locked: 
            case lockedAfterTimeout: {
                server.unlock(lockRequest.getLockOwner(), mo);
            }
        }
    }

    public synchronized void addCounterListener(CounterListener l) {
        if (this.counterListeners == null) {
            this.counterListeners = new Vector(2);
        }
        this.counterListeners.add(l);
    }

    public synchronized void removeCounterListener(CounterListener l) {
        if (this.counterListeners != null) {
            this.counterListeners.remove(l);
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            Vector<CounterListener> listeners = this.counterListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.get(i).incrementCounter(event);
            }
        }
    }

    private static void initRequestPhase(Request request) {
        if (request.getPhase() == -1) {
            request.nextPhase();
        }
    }

    class GetHandler
    implements RequestHandler<SnmpRequest> {
        GetHandler() {
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -96;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            CommandProcessor.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                LockRequest lockRequest = new LockRequest(request, CommandProcessor.this.requestList.getTimeout());
                while (it.hasNext()) {
                    ManagedObject mo;
                    SubRequest sreq = it.next();
                    MOScope scope = sreq.getScope();
                    MOQuery query = sreq.getQuery();
                    if (query == null) {
                        query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName(), false, request);
                        sreq.setQuery(query);
                    }
                    if ((mo = server.lookup(query, lockRequest)) == null) {
                        sreq.getVariableBinding().setVariable((Variable)Null.noSuchObject);
                        sreq.getStatus().setPhaseComplete(true);
                        continue;
                    }
                    try {
                        mo.get(sreq);
                        if (request.getMessageProcessingModel() != 0 || sreq.getVariableBinding().getSyntax() != 70) continue;
                        sreq.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.warn((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(5);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                    }
                    finally {
                        CommandProcessor.this.unlockManagedObjectIfLockedByLookup(server, mo, lockRequest);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }
    }

    class GetNextHandler
    implements RequestHandler<SnmpRequest> {
        GetNextHandler() {
        }

        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            CommandProcessor.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.next();
                    CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -95;
        }
    }

    class SetHandler
    implements RequestHandler<SnmpRequest> {
        SetHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void prepare(OctetString context, SnmpRequest request, MOServer server) {
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                LockRequest lockRequest = new LockRequest(request, CommandProcessor.this.requestList.getTimeout());
                while (!request.isPhaseComplete() && it.hasNext()) {
                    SubRequest sreq = it.next();
                    if (sreq.isComplete()) continue;
                    MOScope scope = sreq.getScope();
                    MOQuery query = sreq.getQuery();
                    if (query == null) {
                        query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName(), true, request);
                        sreq.setQuery(query);
                    }
                    if (!query.getScope().isCovered(new DefaultMOContextScope(context, scope))) {
                        sreq.getStatus().setErrorStatus(6);
                        continue;
                    }
                    ManagedObject mo = server.lookup(query, lockRequest);
                    if (mo == null) {
                        if (query instanceof VACMQuery && !((VACMQuery)query).isAccessAllowed(scope.getLowerBound())) {
                            sreq.getStatus().setErrorStatus(6);
                            return;
                        } else {
                            sreq.getStatus().setErrorStatus(11);
                        }
                        return;
                    }
                    sreq.setTargetMO(mo);
                    if (lockRequest.getLockRequestStatus() == LockRequest.LockStatus.lockTimedOut) {
                        logger.warn((Serializable)((Object)("Set request " + request + " failed because " + mo + " could not be locked")));
                        if (sreq.getStatus().getErrorStatus() != 0) continue;
                        sreq.getStatus().setErrorStatus(5);
                        continue;
                    }
                    try {
                        mo.prepare(sreq);
                    }
                    catch (Exception moex) {
                        logger.error((CharSequence)("Set request " + request + " failed with exception"), (Throwable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(5);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            OctetString context;
            block10: {
                context = request.getContext();
                try {
                    while (request.getPhase() < 4) {
                        int phase = request.nextPhase();
                        switch (phase) {
                            case 1: {
                                this.prepare(context, request, server);
                                break;
                            }
                            case 2: {
                                this.commit(context, request, server);
                                break;
                            }
                            case 3: {
                                this.undo(context, request, server);
                                break;
                            }
                            case 4: {
                                this.cleanup(context, request, server);
                                return;
                            }
                        }
                        if (request.isPhaseComplete()) continue;
                        return;
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        ex.printStackTrace();
                    }
                    logger.error((CharSequence)"Failed to process SET request, trying to clean it up...", (Throwable)ex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block10;
                    throw new RuntimeException(ex);
                }
            }
            this.cleanup(context, request, server);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void undo(OctetString context, SnmpRequest request, MOServer server) {
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.next();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    ManagedObject mo = sreq.getTargetMO();
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        mo = server.lookup(new MOQueryWithSource(scope, true, request));
                    }
                    if (mo == null) {
                        sreq.getStatus().setErrorStatus(15);
                        continue;
                    }
                    try {
                        mo.undo(sreq);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(15);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void commit(OctetString context, SnmpRequest request, MOServer server) {
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (request.getErrorStatus() == 0 && it.hasNext()) {
                    SnmpSubRequest sreq = it.next();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    ManagedObject mo = sreq.getTargetMO();
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        mo = server.lookup(new MOQueryWithSource(scope, true, request));
                    }
                    if (mo == null) {
                        sreq.getStatus().setErrorStatus(14);
                        continue;
                    }
                    try {
                        mo.commit(sreq);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(14);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void cleanup(OctetString context, SnmpRequest request, MOServer server) {
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.next();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    ManagedObject mo = sreq.getTargetMO();
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        mo = server.lookup(new DefaultMOQuery(scope));
                    }
                    if (mo == null) {
                        sreq.completed();
                        continue;
                    }
                    server.unlock(sreq.getRequest(), mo);
                    try {
                        mo.cleanup(sreq);
                        sreq.getStatus().setPhaseComplete(true);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error((Serializable)moex);
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                        return;
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                if (!logger.isDebugEnabled()) return;
                nsex.printStackTrace();
            }
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -93;
        }
    }

    class GetBulkHandler
    implements RequestHandler<SnmpRequest> {
        GetBulkHandler() {
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -91;
        }

        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            block8: {
                CommandProcessor.initRequestPhase(request);
                OctetString context = request.getContext();
                int nonRep = request.getNonRepeaters();
                try {
                    SnmpSubRequest sreq;
                    int i;
                    Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                    for (i = 0; i < nonRep && it.hasNext(); ++i) {
                        sreq = it.next();
                        if (sreq.isComplete()) continue;
                        CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                    }
                    if (request.getMaxRepetitions() > 0) {
                        while (it.hasNext()) {
                            sreq = it.next();
                            if (!sreq.isComplete()) {
                                CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                                sreq.updateNextRepetition();
                            }
                            ++i;
                        }
                    } else {
                        while (it.hasNext()) {
                            sreq = it.next();
                            sreq.completed();
                            ++i;
                        }
                    }
                }
                catch (NoSuchElementException nsex) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Serializable)((Object)"GETBULK request response PDU size limit reached"));
                }
            }
        }
    }

    static class DefaultRequestFactory
    implements RequestFactory<CommandResponderEvent, PDU, SnmpRequest> {
        DefaultRequestFactory() {
        }

        @Override
        public SnmpRequest createRequest(CommandResponderEvent initiatingEvent, CoexistenceInfo cinfo) {
            return new SnmpRequest(initiatingEvent, cinfo);
        }
    }

    class Command
    implements WorkerTask {
        private CommandResponderEvent request;
        private CoexistenceInfo cinfo;

        public Command(CommandResponderEvent event, CoexistenceInfo cinfo) {
            this.request = event;
            this.cinfo = cinfo;
        }

        public void run() {
            CommandProcessor.this.dispatchCommand(this.request, this.cinfo);
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }

    class ProxyCommand
    implements WorkerTask {
        private ProxyForwardRequest request;
        private ProxyForwarder forwarder;

        public ProxyCommand(ProxyForwarder forwarder, ProxyForwardRequest event) {
            this.forwarder = forwarder;
            this.request = event;
        }

        public void run() {
            if (this.forwarder.forward(this.request)) {
                PDU response = this.request.getResponsePDU();
                if (response != null) {
                    CommandProcessor.this.sendResponse(this.request.getCommandEvent(), response);
                }
            } else if (this.request.getProxyType() != 3) {
                CounterEvent cevent = new CounterEvent((Object)this, SnmpConstants.snmpProxyDrops);
                CommandProcessor.this.fireIncrementCounter(cevent);
                CommandResponderEvent cre = this.request.getCommandEvent();
                if (cre.getMessageProcessingModel() == 3 && cre.getStateReference() != null) {
                    ScopedPDU reportPDU = new ScopedPDU();
                    reportPDU.setType(-88);
                    reportPDU.setContextEngineID(this.request.getContextEngineID());
                    reportPDU.setContextName(this.request.getContext());
                    reportPDU.add(new VariableBinding(SnmpConstants.snmpProxyDrops, cevent.getCurrentValue()));
                    CommandProcessor.this.sendResponse(this.request.getCommandEvent(), (PDU)reportPDU);
                }
            }
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }

    class VACMQuery
    extends MOQueryWithSource {
        private OctetString viewName;

        public VACMQuery(OctetString context, OID lowerBound, boolean isLowerIncluded, OID upperBound, boolean isUpperIncluded, OctetString viewName) {
            super(new DefaultMOContextScope(context, lowerBound, isLowerIncluded, upperBound, isUpperIncluded), false, null);
            this.viewName = viewName;
        }

        public VACMQuery(OctetString context, OID lowerBound, boolean isLowerIncluded, OID upperBound, boolean isUpperIncluded, OctetString viewName, boolean isWriteAccessIntended, SnmpRequest source) {
            super(new DefaultMOContextScope(context, lowerBound, isLowerIncluded, upperBound, isUpperIncluded), isWriteAccessIntended, source);
            this.viewName = viewName;
        }

        public boolean isSearchQuery() {
            MOContextScope scope = this.getScope();
            return !scope.isLowerIncluded() && (scope.getUpperBound() == null || !scope.getUpperBound().equals((Object)scope.getLowerBound()));
        }

        @Override
        public boolean matchesQuery(ManagedObject managedObject) {
            OID oid;
            if (this.isSearchQuery()) {
                oid = managedObject.find(this.getScope());
                if (oid == null) {
                    return false;
                }
            } else {
                oid = this.getScope().getLowerBound();
            }
            return CommandProcessor.this.vacm.isAccessAllowed(this.viewName, oid) == 0;
        }

        public boolean isAccessAllowed(OID oid) {
            return CommandProcessor.this.vacm.isAccessAllowed(this.viewName, oid) == 0;
        }

        @Override
        public String toString() {
            return super.toString() + "[viewName=" + this.viewName + "]";
        }
    }
}

