/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRelation;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.tc.SnmpEngineIDTC;
import org.snmp4j.agent.mo.util.RowIndexComparator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpCommunityMIB
implements MOGroup,
CoexistenceInfoProvider {
    private static MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmpCommunityEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 18, 1, 1, 1});
    public static final int colSnmpCommunityName = 2;
    public static final int colSnmpCommunitySecurityName = 3;
    public static final int colSnmpCommunityContextEngineID = 4;
    public static final int colSnmpCommunityContextName = 5;
    public static final int colSnmpCommunityTransportTag = 6;
    public static final int colSnmpCommunityStorageType = 7;
    public static final int colSnmpCommunityStatus = 8;
    public static final int idxSnmpCommunityName = 0;
    public static final int idxSnmpCommunitySecurityName = 1;
    public static final int idxSnmpCommunityContextEngineID = 2;
    public static final int idxSnmpCommunityContextName = 3;
    public static final int idxSnmpCommunityTransportTag = 4;
    public static final int idxSnmpCommunityStorageType = 5;
    public static final int idxSnmpCommunityStatus = 6;
    private static MOTableSubIndex[] snmpCommunityEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 4, 1, 32)};
    private static MOTableIndex snmpCommunityEntryIndex = moFactory.createIndex(snmpCommunityEntryIndexes, true);
    private MOTable<SnmpCommunityEntryRow, MOColumn, MOMutableTableModel<SnmpCommunityEntryRow>> snmpCommunityEntry;
    private MOMutableTableModel<SnmpCommunityEntryRow> snmpCommunityEntryModel;
    public static final OID oidSnmpTargetAddrExtEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 18, 1, 2, 1});
    public static final int colSnmpTargetAddrTMask = 1;
    public static final int colSnmpTargetAddrMMS = 2;
    public static final int idxSnmpTargetAddrTMask = 0;
    public static final int idxSnmpTargetAddrMMS = 1;
    private static MOTableSubIndex[] snmpTargetAddrExtEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(null, 4, 1, 32)};
    private static MOTableIndex snmpTargetAddrExtEntryIndex = moFactory.createIndex(snmpTargetAddrExtEntryIndexes, true);
    private MOTable<SnmpTargetAddrExtEntryRow, MOColumn, MOMutableTableModel<SnmpTargetAddrExtEntryRow>> snmpTargetAddrExtEntry;
    private MOMutableTableModel<SnmpTargetAddrExtEntryRow> snmpTargetAddrExtEntryModel;
    private MOTableRelation<SnmpTargetMIB.SnmpTargetAddrEntryRow, SnmpTargetAddrExtEntryRow> snmpTargetAddrEntryRelation;
    private static final LogAdapter logger = LogFactory.getLogger(SnmpCommunityMIB.class);
    private Map<Variable, SortedSet<SnmpCommunityEntryRow>> coexistenceInfo;
    private Map<Variable, List<SnmpCommunityEntryRow>> communityInfo;
    private SnmpTargetMIB targetMIB;
    private boolean sourceAddressFiltering;
    private SnmpEngineIDTC snmpEngineIDTC;

    public SnmpCommunityMIB(SnmpTargetMIB targetMIB) {
        this(new OctetString(targetMIB.getLocalEngineID()));
        this.targetMIB = targetMIB;
        this.setBaseTableSnmpTargetAddrEntry(targetMIB.getSnmpTargetAddrEntry());
    }

    private SnmpCommunityMIB(OctetString localEngineID) {
        this.snmpEngineIDTC = new SnmpEngineIDTC(localEngineID);
        this.createSnmpCommunityEntry();
        this.createSnmpTargetAddrExtEntry();
    }

    public MOTable<SnmpCommunityEntryRow, MOColumn, MOMutableTableModel<SnmpCommunityEntryRow>> getSnmpCommunityEntry() {
        return this.snmpCommunityEntry;
    }

    private void createSnmpCommunityEntry() {
        MOColumn[] snmpCommunityEntryColumns = new MOColumn[7];
        snmpCommunityEntryColumns[0] = new MOMutableColumn(2, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        snmpCommunityEntryColumns[1] = new MOMutableColumn(3, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)snmpCommunityEntryColumns[1]).addMOValueValidationListener(new SnmpCommunitySecurityNameValidator());
        snmpCommunityEntryColumns[2] = this.snmpEngineIDTC.createColumn(4, 4, MOAccessImpl.ACCESS_READ_CREATE, (OctetString)null, true);
        ((MOMutableColumn)snmpCommunityEntryColumns[2]).addMOValueValidationListener(new SnmpCommunityContextEngineIDValidator());
        snmpCommunityEntryColumns[3] = new MOMutableColumn(5, 4, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(new byte[0]), true);
        ((MOMutableColumn)snmpCommunityEntryColumns[3]).addMOValueValidationListener(new SnmpCommunityContextNameValidator());
        snmpCommunityEntryColumns[4] = new MOMutableColumn(6, 4, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(new byte[0]), true);
        ((MOMutableColumn)snmpCommunityEntryColumns[4]).addMOValueValidationListener(new SnmpCommunityTransportTagValidator());
        snmpCommunityEntryColumns[5] = new StorageType(7, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        snmpCommunityEntryColumns[6] = new RowStatus(8);
        this.snmpCommunityEntryModel = new DefaultMOMutableTableModel<SnmpCommunityEntryRow>();
        this.snmpCommunityEntryModel.setRowFactory(new SnmpCommunityEntryRowFactory());
        this.snmpCommunityEntry = moFactory.createTable(oidSnmpCommunityEntry, snmpCommunityEntryIndex, snmpCommunityEntryColumns, this.snmpCommunityEntryModel);
    }

    public MOTable getSnmpTargetAddrExtEntry() {
        return this.snmpTargetAddrExtEntry;
    }

    public void setBaseTableSnmpTargetAddrEntry(MOTable<SnmpTargetMIB.SnmpTargetAddrEntryRow, ? extends MOColumn, ? extends MOTableModel<SnmpTargetMIB.SnmpTargetAddrEntryRow>> baseTable) {
        this.snmpTargetAddrEntryRelation = moFactory.createTableRelation(baseTable, this.snmpTargetAddrExtEntry);
        this.snmpTargetAddrEntryRelation.createRelationShip();
    }

    private void createSnmpTargetAddrExtEntry() {
        MOColumn[] snmpTargetAddrExtEntryColumns = new MOColumn[2];
        snmpTargetAddrExtEntryColumns[0] = new MOMutableColumn(1, 4, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(new byte[0]), true);
        ((MOMutableColumn)snmpTargetAddrExtEntryColumns[0]).addMOValueValidationListener(new SnmpTargetAddrTMaskValidator());
        snmpTargetAddrExtEntryColumns[1] = new MOMutableColumn(2, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(484), true);
        ((MOMutableColumn)snmpTargetAddrExtEntryColumns[1]).addMOValueValidationListener(new SnmpTargetAddrMMSValidator());
        this.snmpTargetAddrExtEntryModel = new DefaultMOMutableTableModel<SnmpTargetAddrExtEntryRow>();
        this.snmpTargetAddrExtEntryModel.setRowFactory(new SnmpTargetAddrExtEntryRowFactory());
        this.snmpTargetAddrExtEntry = moFactory.createTable(oidSnmpTargetAddrExtEntry, snmpTargetAddrExtEntryIndex, snmpTargetAddrExtEntryColumns, this.snmpTargetAddrExtEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpCommunityEntry, context);
        server.register(this.snmpTargetAddrExtEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpCommunityEntry, context);
        server.unregister(this.snmpTargetAddrExtEntry, context);
    }

    @Override
    public CoexistenceInfo[] getCoexistenceInfo(OctetString community) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Looking up coexistence info for '" + community + "'")));
        }
        if (this.coexistenceInfo == null) {
            return null;
        }
        SortedSet<SnmpCommunityEntryRow> cinfos = this.coexistenceInfo.get(community);
        if (cinfos != null) {
            TreeSet<SnmpCommunityEntryRow> cinfosCopy = new TreeSet<SnmpCommunityEntryRow>(cinfos);
            ArrayList<CoexistenceInfo> infos = new ArrayList<CoexistenceInfo>(cinfosCopy.size());
            for (SnmpCommunityEntryRow row : cinfosCopy) {
                SnmpCommunityEntryRow modelRow = (SnmpCommunityEntryRow)this.getSnmpCommunityEntry().getModel().getRow(row.getIndex());
                if (modelRow != row) {
                    cinfos.remove(row);
                    if (modelRow == null) continue;
                    cinfos.add(modelRow);
                    row = modelRow;
                }
                if (row.getSnmpCommunityStatus() == null || row.getSnmpCommunityStatus().getValue() != 1) continue;
                CoexistenceInfo coexistenceInfo = new CoexistenceInfo(row.getSnmpCommunitySecurityName(), row.getSnmpCommunityContextEngineID(), row.getSnmpCommunityContextName(), row.getSnmpCommunityTransportTag());
                infos.add(coexistenceInfo);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Serializable)((Object)("Found coexistence info for '" + community + "'=" + coexistenceInfo)));
            }
            return infos.toArray(new CoexistenceInfo[infos.size()]);
        }
        return null;
    }

    @Override
    public boolean passesFilter(Address address, CoexistenceInfo coexistenceInfo) {
        if (!this.isSourceAddressFiltering()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Address " + address + " passes filter, because source address filtering is disabled")));
            }
            return true;
        }
        if (coexistenceInfo.getTransportTag() == null || coexistenceInfo.getTransportTag().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Address " + address + " passes filter, because transportTag is null")));
            }
            return true;
        }
        Collection<SnmpTargetMIB.SnmpTargetAddrEntryRow> matches = this.targetMIB.getTargetAddrRowsForTag(coexistenceInfo.getTransportTag());
        Iterator<SnmpTargetMIB.SnmpTargetAddrEntryRow> iterator = matches.iterator();
        while (iterator.hasNext()) {
            OctetString maskedMatchTAddress;
            OctetString maskedFilterTAddress;
            SnmpTargetMIB.SnmpTargetAddrEntryRow match;
            SnmpTargetMIB.SnmpTargetAddrEntryRow row = match = iterator.next();
            SnmpTargetAddrExtEntryRow extRow = (SnmpTargetAddrExtEntryRow)this.snmpTargetAddrExtEntryModel.getRow(row.getIndex());
            OctetString filterTAddress = (OctetString)row.getValue(1);
            if (extRow == null) continue;
            OctetString mask = extRow.getSnmpTargetAddrTMask();
            OctetString matchAddress = row.getTAddress(address);
            if (mask.length() == 0 && matchAddress != null && matchAddress.equals((Object)filterTAddress)) {
                coexistenceInfo.setMaxMessageSize(extRow.getSnmpTargetAddrMMS().getValue());
                return true;
            }
            if (matchAddress == null || mask.length() != matchAddress.length() || matchAddress.length() != filterTAddress.length() || !(maskedFilterTAddress = filterTAddress.mask(mask)).equals((Object)(maskedMatchTAddress = matchAddress.mask(mask)))) continue;
            coexistenceInfo.setMaxMessageSize(extRow.getSnmpTargetAddrMMS().getValue());
            return true;
        }
        return false;
    }

    public void setSourceAddressFiltering(boolean sourceAddressFiltering) {
        this.sourceAddressFiltering = sourceAddressFiltering;
    }

    public boolean isSourceAddressFiltering() {
        return this.sourceAddressFiltering;
    }

    @Override
    public OctetString getCommunity(OctetString securityName, OctetString contextEngineID, OctetString contextName) {
        if (this.communityInfo == null) {
            return null;
        }
        List<SnmpCommunityEntryRow> l = this.communityInfo.get(securityName);
        if (l != null) {
            for (SnmpCommunityEntryRow row : l) {
                if (row.getSnmpCommunityStatus().getValue() != 1 || contextEngineID != null && !contextEngineID.equals((Object)row.getSnmpCommunityContextEngineID()) || !row.getSnmpCommunityContextName().equals((Object)contextName)) continue;
                return row.getSnmpCommunityName();
            }
        }
        return null;
    }

    public void addSnmpCommunityEntry(OctetString indexName, OctetString community, OctetString securityName, OctetString contextEngineID, OctetString contextName, OctetString communityTransportTag, int storageType) {
        if (indexName.length() > 32) {
            throw new IllegalArgumentException("The length of the snmpCommunityIndex (" + indexName.length() + ") exceeds the maximum of 32 bytes");
        }
        this.snmpCommunityEntry.addRow(this.snmpCommunityEntry.createRow(indexName.toSubIndex(true), new Variable[]{community, securityName, contextEngineID, contextName, communityTransportTag, new Integer32(storageType), new Integer32(1)}));
    }

    public boolean removeSnmpCommuntiyEntry(OctetString indexName) {
        SnmpCommunityEntryRow removedRow = this.snmpCommunityEntry.removeRow(indexName.toSubIndex(true));
        if (removedRow != null) {
            this.snmpCommunityEntry.getModel().getRowFactory().freeRow(removedRow);
            return true;
        }
        return false;
    }

    class SnmpTargetAddrExtEntryRow
    extends DefaultMOMutableRow2PC {
        public SnmpTargetAddrExtEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmpTargetAddrTMask() {
            return (OctetString)this.getValue(0);
        }

        public void setSnmpTargetAddrTMask(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getSnmpTargetAddrMMS() {
            return (Integer32)this.getValue(1);
        }

        public void setSnmpTargetAddrMMS(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }
    }

    class SnmpTargetAddrExtEntryRowFactory
    implements MOTableRowFactory<SnmpTargetAddrExtEntryRow> {
        SnmpTargetAddrExtEntryRowFactory() {
        }

        @Override
        public SnmpTargetAddrExtEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            SnmpTargetAddrExtEntryRow row = new SnmpTargetAddrExtEntryRow(index, values);
            return row;
        }

        @Override
        public void freeRow(SnmpTargetAddrExtEntryRow row) {
        }
    }

    public class SnmpCommunityEntryRow
    extends DefaultMOMutableRow2PC {
        public SnmpCommunityEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmpCommunityName() {
            return (OctetString)this.getValue(0);
        }

        public void setSnmpCommunityName(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        @Override
        public void setValue(int column, Variable value) {
            SortedSet<SnmpCommunityEntryRow> cinfos;
            if (column == 0 && (cinfos = (TreeSet<SnmpCommunityEntryRow>)SnmpCommunityMIB.this.coexistenceInfo.get(this.getSnmpCommunityName())) != null) {
                for (SnmpCommunityEntryRow row : cinfos) {
                    if (!row.getIndex().equals((Object)this.getIndex())) continue;
                    cinfos.remove(row);
                    break;
                }
            }
            super.setValue(column, value);
            if (column == 0) {
                cinfos = (SortedSet)SnmpCommunityMIB.this.coexistenceInfo.get(value);
                if (cinfos == null) {
                    cinfos = new TreeSet<SnmpCommunityEntryRow>();
                    SnmpCommunityMIB.this.coexistenceInfo.put(this.values[0], cinfos);
                }
                cinfos.add(this);
            }
        }

        public OctetString getSnmpCommunitySecurityName() {
            return (OctetString)this.getValue(1);
        }

        public void setSnmpCommunitySecurityName(OctetString newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public OctetString getSnmpCommunityContextEngineID() {
            return (OctetString)this.getValue(2);
        }

        public void setSnmpCommunityContextEngineID(OctetString newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public OctetString getSnmpCommunityContextName() {
            return (OctetString)this.getValue(3);
        }

        public void setSnmpCommunityContextName(OctetString newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public OctetString getSnmpCommunityTransportTag() {
            return (OctetString)this.getValue(4);
        }

        public void setSnmpCommunityTransportTag(OctetString newValue) {
            this.setValue(4, (Variable)newValue);
        }

        public Integer32 getSnmpCommunityStorageType() {
            return (Integer32)this.getValue(5);
        }

        public void setSnmpCommunityStorageType(Integer32 newValue) {
            this.setValue(5, (Variable)newValue);
        }

        public Integer32 getSnmpCommunityStatus() {
            return (Integer32)this.getValue(6);
        }

        public void setSnmpCommunityStatus(Integer32 newValue) {
            this.setValue(6, (Variable)newValue);
        }
    }

    class SnmpCommunityEntryRowFactory
    implements MOTableRowFactory<SnmpCommunityEntryRow> {
        SnmpCommunityEntryRowFactory() {
        }

        @Override
        public synchronized SnmpCommunityEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            LinkedList<SnmpCommunityEntryRow> l;
            TreeSet<MOTableRow> cinfos;
            SnmpCommunityEntryRow row = new SnmpCommunityEntryRow(index, values);
            if (SnmpCommunityMIB.this.coexistenceInfo == null) {
                SnmpCommunityMIB.this.coexistenceInfo = Collections.synchronizedMap(new HashMap());
            }
            if ((cinfos = (TreeSet<MOTableRow>)SnmpCommunityMIB.this.coexistenceInfo.get(values[0])) == null) {
                cinfos = new TreeSet<MOTableRow>(new RowIndexComparator());
                SnmpCommunityMIB.this.coexistenceInfo.put(values[0], cinfos);
            }
            cinfos.add(row);
            if (SnmpCommunityMIB.this.communityInfo == null) {
                SnmpCommunityMIB.this.communityInfo = Collections.synchronizedMap(new HashMap());
            }
            if ((l = (LinkedList<SnmpCommunityEntryRow>)SnmpCommunityMIB.this.communityInfo.get(values[1])) == null) {
                l = new LinkedList<SnmpCommunityEntryRow>();
                SnmpCommunityMIB.this.communityInfo.put(values[1], l);
            }
            l.add(row);
            return row;
        }

        @Override
        public synchronized void freeRow(SnmpCommunityEntryRow row) {
            List l;
            SortedSet cinfos = (SortedSet)SnmpCommunityMIB.this.coexistenceInfo.get(row.getValue(0));
            if (cinfos != null) {
                cinfos.remove(row);
                if (cinfos.isEmpty()) {
                    SnmpCommunityMIB.this.coexistenceInfo.remove(row.getValue(0));
                }
            }
            if ((l = (List)SnmpCommunityMIB.this.communityInfo.get(row.getValue(1))) != null) {
                l.remove(row);
                if (l.size() == 0) {
                    SnmpCommunityMIB.this.communityInfo.remove(row.getValue(1));
                }
            }
        }
    }

    static class SnmpTargetAddrMMSValidator
    implements MOValueValidationListener {
        SnmpTargetAddrMMSValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            long v = ((Integer32)newValue).getValue();
            if ((v < 0L || v > 0L) && v < 484L) {
                validationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    static class SnmpTargetAddrTMaskValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTMaskValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpCommunityTransportTagValidator
    implements MOValueValidationListener {
        SnmpCommunityTransportTagValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpCommunityContextNameValidator
    implements MOValueValidationListener {
        SnmpCommunityContextNameValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpCommunityContextEngineIDValidator
    implements MOValueValidationListener {
        SnmpCommunityContextEngineIDValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 5 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpCommunitySecurityNameValidator
    implements MOValueValidationListener {
        SnmpCommunitySecurityNameValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 1 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }
}

