/*_############################################################################
  _## 
  _##  SNMP4J-Agent 3 - ChangeableManagedObject.java  
  _## 
  _##  Copyright (C) 2005-2018  Frank Fock (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/

package org.snmp4j.agent.mo;

import org.snmp4j.agent.ManagedObject;

/**
 * The {@link ChangeableManagedObject} interface extends the {@link ManagedObject} by methods
 * to add/remove {@link MOChangeListener} that should be informed when the object implementing this
 * interface changes.
 *
 * @author Frank Fock
 * @since 3.0
 */
public interface ChangeableManagedObject extends ManagedObject {

    /**
     * Adds a {@code MOChangeListener} that needs to be informed about
     * state changes of this {@link ManagedObject}.
     * @param l
     *    a {@code MOChangeListener} instance.
     * @since 3.0
     */
    void addMOChangeListener(MOChangeListener l);

    /**
     * Removes a {@code MOChangeListener} from this {@link ManagedObject}.
     * @param l
     *    a {@code MOChangeListener} instance.
     * @since 3.0
     */
    void removeMOChangeListener(MOChangeListener l);

}
