/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.RowModificationControlColumn;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class StorageType
extends MOMutableColumn
implements RowModificationControlColumn {
    public static final int other = 1;
    public static final int volatile_ = 2;
    public static final int nonVolatile = 3;
    public static final int permanent = 4;
    public static final int readOnly = 5;

    public StorageType(int columnID, MOAccess access, Integer32 defaultValue, boolean mutableInService) {
        super(columnID, 2, access, (Variable)defaultValue, mutableInService);
    }

    public StorageType(int columnID, MOAccess access, Integer32 defaultValue) {
        super(columnID, 2, access, (Variable)defaultValue);
    }

    @Override
    public synchronized int validate(Variable newValue, Variable oldValue) {
        int v = ((Integer32)newValue).getValue();
        if (v < 1 || v > 5) {
            return 10;
        }
        if (oldValue != null) {
            int ov = ((Integer32)oldValue).getValue();
            if (ov < 4 && v >= 4) {
                return 10;
            }
            if (ov >= 4) {
                return 10;
            }
        }
        return super.validate(newValue, oldValue);
    }

    @Override
    public void prepareRow(SubRequest subRequest, MOMutableTableRow currentRow, MOTableRow changeSet) {
        Integer32 currentValue = (Integer32)currentRow.getValue(this.getTable().getColumnIndex(this.getColumnID()));
        switch (currentValue.getValue()) {
            case 4: {
                break;
            }
            case 5: {
                subRequest.setErrorStatus(17);
            }
        }
    }

    @Override
    public boolean isVolatile(MOTableRow row, int column) {
        Integer32 value = (Integer32)row.getValue(column);
        if (value != null) {
            int storageType = value.getValue();
            switch (storageType) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static enum StorageTypeEnum {
        other,
        volatile_,
        nonVolatile,
        permanent,
        readOnly;


        public static StorageTypeEnum fromValue(int storageTypeValue) {
            switch (storageTypeValue) {
                case 1: {
                    return other;
                }
                case 2: {
                    return volatile_;
                }
                case 3: {
                    return nonVolatile;
                }
                case 4: {
                    return permanent;
                }
                case 5: {
                    return readOnly;
                }
            }
            return null;
        }

        public int getValue() {
            return this.ordinal() + 1;
        }
    }
}

