/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.util;

import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.smi.OID;

public class MOTableSizeLimit<R extends MOTableRow>
implements MOTableRowListener<R> {
    public static final String PROPERTY_PREFIX = "snmp4j.tableSizeLimit.";
    private int maxNumRows = 0;
    private SortedMap<OID, Integer> limits;

    public MOTableSizeLimit(int maxNumRows) {
        this.maxNumRows = maxNumRows;
    }

    public MOTableSizeLimit(Properties limits) {
        this.setLimits(limits);
    }

    @Override
    public void rowChanged(MOTableRowEvent<R> event) {
        if (event.getType() == 2 && !this.checkLimits(event)) {
            event.setVetoStatus(13);
        }
    }

    private boolean checkLimits(MOTableRowEvent<R> event) {
        int limit = this.maxNumRows;
        if (this.limits != null && !this.limits.isEmpty()) {
            OID search = new OID(event.getTable().getOID());
            while (search.size() > 0) {
                Integer l = (Integer)this.limits.get(search);
                if (l != null) {
                    limit = l;
                    break;
                }
                search.trim(1);
            }
        }
        int currentSize = 0;
        if (limit > 0 && (currentSize = event.getTable().getModel().getRowCount()) >= limit) {
            return this.removeEldest(event, currentSize - limit + 1);
        }
        return limit <= 0;
    }

    protected boolean removeEldest(MOTableRowEvent<R> triggeringEvent, int numRows) {
        return false;
    }

    public void setMaxNumRows(int maxNumRows) {
        this.maxNumRows = maxNumRows;
    }

    public int getMaxNumRows() {
        return this.maxNumRows;
    }

    public SortedMap<OID, Integer> getLimits() {
        return this.limits;
    }

    public void setLimits(Properties limits) {
        this.limits = new TreeMap<OID, Integer>();
        for (Map.Entry<Object, Object> entry : limits.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROPERTY_PREFIX)) continue;
            this.limits.put(new OID(key.substring(PROPERTY_PREFIX.length())), Integer.valueOf(entry.getValue().toString()));
        }
    }
}

