/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.Context;
import org.snmp4j.agent.io.MOInfo;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.agent.mo.MOPriorityProvider;
import org.snmp4j.agent.util.MOScopePriorityComparator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class MOServerPersistence {
    private static final LogAdapter logger = LogFactory.getLogger(MOServerPersistence.class);
    private final MOServer[] servers;

    public MOServerPersistence(MOServer server) {
        this(new MOServer[]{server});
    }

    public MOServerPersistence(MOServer[] moServers) {
        this.servers = moServers;
    }

    private HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject<?>>> buildCache(MOPriorityProvider priorityProvider) {
        HashMap serializableMO = new HashMap();
        SortedMap<OID, Integer> priorityMap = null;
        ManagedObject<?> bootMO = null;
        if (priorityProvider != null) {
            priorityMap = priorityProvider.getPriorityMap(null);
            bootMO = priorityProvider.getBootManagedObject(null);
        }
        for (MOServer server : this.servers) {
            MOScopeComparator scopeComparator = new MOScopeComparator();
            if (priorityMap != null && bootMO != null) {
                priorityMap.put(bootMO.getScope().getLowerBound(), -1);
                scopeComparator = new MOScopePriorityComparator(priorityMap);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Using priority map " + priorityMap + " to prepare managed object de/serialization")));
                }
            }
            Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator(scopeComparator, null);
            while (it.hasNext()) {
                Map.Entry<MOScope, ManagedObject<?>> entry = it.next();
                MOScope scope = entry.getKey();
                ManagedObject<?> value = entry.getValue();
                if (!(value instanceof SerializableManagedObject) || ((SerializableManagedObject)value).isVolatile()) continue;
                OctetString context = null;
                if (scope instanceof MOContextScope) {
                    context = ((MOContextScope)scope).getContext();
                }
                LinkedHashMap objects = serializableMO.computeIfAbsent(context, k -> new LinkedHashMap());
                objects.put(((SerializableManagedObject)value).getID(), (SerializableManagedObject)value);
            }
        }
        return serializableMO;
    }

    public synchronized void loadData(MOInput input) throws IOException {
        int i;
        HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject<?>>> serializableMO = this.buildCache(null);
        LinkedHashMap<OID, SerializableManagedObject<?>> mos = serializableMO.get(null);
        if (mos != null) {
            MOServerPersistence.readData(input, mos);
        } else {
            Sequence seq = input.readSequence();
            for (i = 0; i < seq.getSize(); ++i) {
                MOInfo mo = input.readManagedObject();
                input.skipManagedObject(mo);
            }
        }
        Sequence contextSequence = input.readSequence();
        if (contextSequence != null) {
            for (i = 0; i < contextSequence.getSize(); ++i) {
                Context context = input.readContext();
                boolean skip = true;
                for (int s = 0; skip && s < this.servers.length; ++s) {
                    if (!this.servers[s].isContextSupported(context.getContext())) continue;
                    skip = false;
                }
                if (skip) {
                    logger.warn((Serializable)((Object)("Context '" + context.getContext() + "' is no longer supported by agent")));
                    input.skipContext(context);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Loading data for context '" + context.getContext() + "'")));
                }
                if ((mos = serializableMO.get(context.getContext())) == null) {
                    input.skipContext(context);
                    continue;
                }
                MOServerPersistence.readData(input, mos);
                input.skipContext(context);
            }
        }
    }

    private static void readData(MOInput input, LinkedHashMap<OID, SerializableManagedObject<?>> mos) throws IOException {
        Sequence moGroup = input.readSequence();
        if (moGroup != null) {
            for (int j = 0; j < moGroup.getSize(); ++j) {
                SerializableManagedObject<?> mo;
                MOInfo moid = input.readManagedObject();
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Looking up object " + moid.getOID())));
                }
                if ((mo = mos.get(moid.getOID())) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Loading data for object " + moid.getOID())));
                    }
                    mo.load(input);
                }
                input.skipManagedObject(moid);
            }
        }
    }

    public synchronized void saveData(MOOutput output) throws IOException {
        this.saveData(output, null);
    }

    private static void writeData(MOOutput output, Context c, LinkedHashMap<? extends OID, SerializableManagedObject<?>> mos) throws IOException {
        if (logger.isDebugEnabled()) {
            if (c == null) {
                logger.debug((Serializable)((Object)("Writing " + mos.size() + " context independent managed objects")));
            } else {
                logger.debug((Serializable)((Object)("Writing " + mos.size() + " managed objects for context '" + c.getContext() + "'")));
            }
        }
        output.writeSequence(new Sequence(mos.size()));
        for (SerializableManagedObject<?> mo : mos.values()) {
            MOInfo moInfo = new MOInfo(mo.getID());
            output.writeManagedObjectBegin(moInfo);
            mo.save(output);
            output.writeManagedObjectEnd(moInfo);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Serializable)((Object)("Wrote data of " + moInfo.getOID())));
        }
    }

    public void saveData(MOOutput output, MOPriorityProvider priorityProvider) throws IOException {
        HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject<?>>> serializableMO = this.buildCache(priorityProvider);
        LinkedHashMap<OID, SerializableManagedObject<?>> mos = serializableMO.get(null);
        if (mos != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Trying to write MIB data for all contexts: " + mos.keySet())));
            }
            MOServerPersistence.writeData(output, null, mos);
        } else {
            output.writeSequence(new Sequence(0));
        }
        HashSet<OctetString> contextSet = new HashSet<OctetString>();
        for (MOServer server : this.servers) {
            contextSet.addAll(Arrays.asList(server.getContexts()));
        }
        OctetString[] contexts = contextSet.toArray(new OctetString[0]);
        output.writeSequence(new Sequence(contexts.length));
        for (OctetString context : contexts) {
            Context c = new Context(context);
            output.writeContextBegin(c);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Trying to write MIB data for context '" + c.getContext() + "'")));
            }
            if ((mos = serializableMO.get(c.getContext())) != null) {
                MOServerPersistence.writeData(output, c, mos);
            }
            output.writeContextEnd(c);
        }
    }
}

