/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.tc.SnmpAdminStringTC;
import org.snmp4j.agent.mo.snmp.tc.SnmpEngineIDTC;
import org.snmp4j.agent.mo.snmp.tc.TCModule;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SnmpFrameworkMIB
implements MOGroup,
TCModule {
    public static final String MODULE_NAME = "SNMP-FRAMEWORK-MIB";
    private USM usm;
    private OctetString engineId;
    private Collection<TransportMapping<? extends Address>> transportMappings;
    private MOScalar<OctetString> snmpEngineID;
    private MOScalar<Integer32> snmpEngineBoots;
    private MOScalar<Integer32> snmpEngineTime;
    private MOScalar<Integer32> snmpEngineMaxMessageSize;
    public static final String SNMPADMINSTRING = "SnmpAdminString";
    public static final String SNMPENGINEID = "SnmpEngineID";
    private Map<String, TextualConvention<?>> textualConventions;

    public SnmpFrameworkMIB(OctetString engineId, USM usm, Collection<TransportMapping<? extends Address>> transportMappings) {
        this.engineId = engineId;
        this.usm = usm;
        this.transportMappings = transportMappings;
        this.createMOs();
        this.textualConventions = new HashMap(2);
        this.textualConventions.put(SNMPADMINSTRING, new SnmpAdminStringTC());
        this.textualConventions.put(SNMPENGINEID, new SnmpEngineIDTC(this.snmpEngineID.getValue()));
    }

    @Deprecated
    public SnmpFrameworkMIB(OctetString engineId, USM usm, Collection<TransportMapping<? extends Address>> transportMappings, boolean updateUsmFromMIB) {
        this(engineId, usm, transportMappings);
    }

    private void createMOs() {
        this.snmpEngineID = new MOScalar<OctetString>(new OID("1.3.6.1.6.3.10.2.1.1.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            @Override
            public OctetString getValue() {
                return SnmpFrameworkMIB.this.engineId;
            }
        };
        this.snmpEngineBoots = new MOScalar<Integer32>(new OID("1.3.6.1.6.3.10.2.1.2.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            @Override
            public Integer32 getValue() {
                return new Integer32(SnmpFrameworkMIB.this.usm.getEngineBoots());
            }
        };
        this.snmpEngineTime = new MOScalar<Integer32>(new OID("1.3.6.1.6.3.10.2.1.3.0"), MOAccessImpl.ACCESS_READ_ONLY, null){

            @Override
            public Integer32 getValue() {
                return new Integer32(SnmpFrameworkMIB.this.usm.getEngineTime());
            }
        };
        Integer32 maxMsgSize = new Integer32(this.getMaxMessageSize());
        this.snmpEngineMaxMessageSize = new MOScalar<Integer32>(new OID("1.3.6.1.6.3.10.2.1.4.0"), MOAccessImpl.ACCESS_READ_ONLY, maxMsgSize);
    }

    private int getMaxMessageSize() {
        int totalMaxMessageSize = Integer.MAX_VALUE;
        for (TransportMapping<? extends Address> transportMapping : this.transportMappings) {
            int maxMsgSize = transportMapping.getMaxInboundMessageSize();
            totalMaxMessageSize = Math.min(totalMaxMessageSize, maxMsgSize);
        }
        return totalMaxMessageSize;
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpEngineID, context);
        if (this.usm != null) {
            server.register(this.snmpEngineBoots, context);
            server.register(this.snmpEngineTime, context);
        }
        server.register(this.snmpEngineMaxMessageSize, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpEngineID, context);
        server.unregister(this.snmpEngineBoots, context);
        server.unregister(this.snmpEngineTime, context);
        server.unregister(this.snmpEngineMaxMessageSize, context);
    }

    public MOScalar<Integer32> getSnmpEngineBoots() {
        return this.snmpEngineBoots;
    }

    public MOScalar<OctetString> getSnmpEngineID() {
        return this.snmpEngineID;
    }

    public MOScalar<Integer32> getSnmpEngineMaxMessageSize() {
        return this.snmpEngineMaxMessageSize;
    }

    public MOScalar<Integer32> getSnmpEngineTime() {
        return this.snmpEngineTime;
    }

    public USM getUSM() {
        return this.usm;
    }

    @Deprecated
    public boolean isUpdateUsmFromMIB() {
        return false;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public TextualConvention<?> getTextualConvention(String name) {
        return this.textualConventions.get(name);
    }

    @Override
    public Collection<? extends TextualConvention<?>> getTextualConventions() {
        return this.textualConventions.values();
    }
}

